/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.local.repository.internal;

import com.bizunited.nebula.common.repository.PageRepositoryImpl;
import com.bizunited.nebula.europa.local.entity.EuropaInfoEntity;
import com.bizunited.nebula.europa.local.repository.internal.EuropaInfoRepositoryCustom;
import com.bizunited.nebula.europa.sdk.dto.EuropaInfoDto;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class EuropaInfoRepositoryImpl
implements EuropaInfoRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<EuropaInfoEntity> findByConditions(Pageable pageable, EuropaInfoDto europaInfoDto) {
        StringBuilder hql = new StringBuilder("from EuropaInfoEntity r where 1 = 1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from EuropaInfoEntity r where 1 = 1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, String> parameter = new HashMap<String, String>();
        condition.append(" AND r.tenantCode = :tenantCode ");
        parameter.put("tenantCode", europaInfoDto.getTenantCode());
        if (StringUtils.isNotBlank((CharSequence)europaInfoDto.getCode())) {
            condition.append(" AND r.code = :code ");
            parameter.put("code", europaInfoDto.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)europaInfoDto.getName())) {
            condition.append(" AND r.name like CONCAT('%',:name,'%') ");
            parameter.put("name", europaInfoDto.getName());
        }
        hql.append((CharSequence)condition).append(" order by r.name desc");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
    }
}

