/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.local.entity.EuropaInfoEntity;
import com.bizunited.nebula.europa.local.repository.EuropaInfoRepository;
import com.bizunited.nebula.europa.sdk.dto.EuropaInfoDto;
import com.bizunited.nebula.europa.sdk.event.EuropaInfoEventListener;
import com.bizunited.nebula.europa.sdk.service.EuropaInfoVoService;
import com.bizunited.nebula.europa.sdk.service.strategy.EuropaInfoMaintainStrategy;
import com.bizunited.nebula.europa.sdk.strategy.ViewInfoConvertStrategy;
import com.bizunited.nebula.europa.sdk.vo.AbstractView;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="EuropaInfoVoService")
public class EuropaInfoVoServiceImpl
implements EuropaInfoVoService {
    @Autowired
    @Lazy
    private Set<ViewInfoConvertStrategy> viewInfoConvertStrategies;
    @Autowired
    private EuropaInfoRepository europaInfoRepository;
    @Autowired(required=false)
    @Lazy
    private Set<EuropaInfoEventListener> europaInfoEventListeners;
    @Autowired
    @Lazy
    private Set<EuropaInfoMaintainStrategy> europaInfoMaintainStrategies;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;

    @Transactional
    public EuropaInfoVo create(JSONObject europaInfo) {
        EuropaInfoVo currentEuropaInfoVo = this.convertEuropaInfo(europaInfo, "\u521b\u5efa\u65f6");
        return this.create(currentEuropaInfoVo);
    }

    @Transactional
    public EuropaInfoVo create(EuropaInfoVo europaInfo) {
        String relativeLocal;
        Validate.notNull((Object)europaInfo, (String)"\u521b\u5efa\u65f6\uff0c\u5c06\u8981\u6dfb\u52a0\u7684\u6570\u636e\u89c6\u56fe\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        europaInfo.setTenantCode(tenantCode);
        if (europaInfo.getPageable() == null) {
            europaInfo.setPageable(Boolean.valueOf(true));
        }
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        Object authDetailsObject = authentication.getDetails();
        String account = null;
        if (authDetailsObject instanceof UserIdentity) {
            UserIdentity userIdentity = (UserIdentity)authDetailsObject;
            account = userIdentity.getAccount();
        } else {
            account = this.simpleSecurityProperties.getIndependencyUser();
        }
        Date date = new Date();
        europaInfo.setCreateAccount(account);
        europaInfo.setCreateTime(date);
        europaInfo.setModifyAccount(account);
        europaInfo.setModifyTime(date);
        String id = europaInfo.getId();
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)id), (String)"\u521b\u5efa\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165id\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        europaInfo.setId(null);
        String subSystem = europaInfo.getSubSystem();
        Validate.notBlank((CharSequence)subSystem, (String)"\u521b\u5efa\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u9009\u5b9a\u7684\u5b50\u7cfb\u7edf\u4fe1\u606f", (Object[])new Object[0]);
        String code = europaInfo.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u521b\u5efa\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u89c6\u56fe\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        EuropaInfoEntity currentEuropaInfo = this.europaInfoRepository.findByTenantCodeAndCode(tenantCode, code);
        Validate.isTrue((currentEuropaInfo == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u65f6\uff0c\u5f53\u524d\u4e1a\u52a1\u7f16\u53f7\u5bf9\u5e94\u7684\u6570\u636e\u67e5\u8be2\u89c6\u56fe\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String name = europaInfo.getName();
        Validate.notBlank((CharSequence)name, (String)"\u521b\u5efa\u65f6\uff0c\u6570\u636e\u89c6\u56fe\u7684\u4e2d\u6587\u540d\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String sourceType = europaInfo.getSourceType();
        Validate.notBlank((CharSequence)sourceType, (String)"\u521b\u5efa\u65f6\uff0c\u6570\u636e\u6e90\u7c7b\u578b\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String fileName = europaInfo.getFileName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            europaInfo.setFileName("");
        }
        if (StringUtils.isBlank((CharSequence)(relativeLocal = europaInfo.getRelativeLocal()))) {
            europaInfo.setRelativeLocal("");
        }
        AbstractView abstractView = europaInfo.getView();
        Validate.notNull((Object)abstractView, (String)"\u9519\u8bef\u7684\u8be6\u7ec6\u6570\u636e\u89c6\u56fe\u67e5\u8be2\u6e90\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        EuropaInfoEntity europaInfoEntity = (EuropaInfoEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)europaInfo, EuropaInfoEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.europaInfoRepository.save((Object)europaInfoEntity);
        europaInfo.setId(europaInfoEntity.getId());
        abstractView.setEuropaCode(code);
        EuropaInfoMaintainStrategy matchedEuropaInfoMaintainStrategy = this.matchedEuropaInfoMaintainStrategy(europaInfo);
        Validate.notNull((Object)matchedEuropaInfoMaintainStrategy, (String)"\u9519\u8bef\u7684\u6570\u636e\u89c6\u56fe\u8fd0\u7ef4\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        matchedEuropaInfoMaintainStrategy.create(europaInfo);
        if (!CollectionUtils.isEmpty(this.europaInfoEventListeners)) {
            for (EuropaInfoEventListener europaInfoEventListener : this.europaInfoEventListeners) {
                europaInfoEventListener.onCreate(europaInfo);
            }
        }
        return europaInfo;
    }

    private EuropaInfoVo convertEuropaInfo(JSONObject europaInfo, String onTime) {
        Validate.notNull((Object)europaInfo, (String)(onTime + "\uff0c\u9519\u8bef\u7684json\u683c\u5f0f\u4fe1\u606f"), (Object[])new Object[0]);
        String sourceType = europaInfo.getString("sourceType");
        Validate.notBlank((CharSequence)sourceType, (String)(onTime + "\uff0c\u9519\u8bef\u7684\u6570\u636e\u89c6\u56fe\u5b9e\u73b0\u6e90\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        ViewInfoConvertStrategy matchedViewInfoConvertStrategy = null;
        for (ViewInfoConvertStrategy viewInfoConvertStrategy : this.viewInfoConvertStrategies) {
            if (!StringUtils.equals((CharSequence)viewInfoConvertStrategy.matchedSourceType(), (CharSequence)sourceType)) continue;
            matchedViewInfoConvertStrategy = viewInfoConvertStrategy;
        }
        Validate.notNull((Object)matchedViewInfoConvertStrategy, (String)(onTime + "\uff0c\u672a\u5339\u914d\u5230\u4efb\u4f55\u53ef\u7528\u7684\u6570\u636e\u89c6\u56fe\u4fe1\u606f\u8f6c\u6362\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        final Class abstractView = matchedViewInfoConvertStrategy.getAbstractViewClass();
        Validate.notNull((Object)abstractView, (String)(onTime + "\uff0c\u9519\u8bef\u7684\u7684\u5177\u4f53\u6570\u636e\u89c6\u56fe\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        ParserConfig parserConfig = new ParserConfig(){

            public ObjectDeserializer getDeserializer(Type type) {
                if (type == AbstractView.class) {
                    return super.getDeserializer((Type)abstractView);
                }
                return super.getDeserializer(type);
            }
        };
        EuropaInfoVo currentEuropaInfoVo = (EuropaInfoVo)JSON.parseObject((String)europaInfo.toJSONString(), EuropaInfoVo.class, (ParserConfig)parserConfig, (Feature[])new Feature[0]);
        return currentEuropaInfoVo;
    }

    @Transactional
    public EuropaInfoVo update(JSONObject europaInfo) {
        EuropaInfoVo currentEuropaInfoVo = this.convertEuropaInfo(europaInfo, "\u4fee\u6539\u65f6");
        return this.update(currentEuropaInfoVo);
    }

    @Transactional
    public EuropaInfoVo update(EuropaInfoVo europaInfo) {
        String relativeLocal;
        Validate.notNull((Object)europaInfo, (String)"\u4fee\u6539\u65f6\uff0c\u5c06\u8981\u6dfb\u52a0\u7684\u6570\u636e\u89c6\u56fe\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        Object authDetailsObject = authentication.getDetails();
        String account = null;
        if (authDetailsObject instanceof UserIdentity) {
            UserIdentity userIdentity = (UserIdentity)authDetailsObject;
            account = userIdentity.getAccount();
        } else {
            account = this.simpleSecurityProperties.getIndependencyUser();
        }
        Date date = new Date();
        europaInfo.setModifyAccount(account);
        europaInfo.setModifyTime(date);
        String tenantCode = europaInfo.getTenantCode();
        Validate.notBlank((CharSequence)tenantCode, (String)"\u4fee\u6539\u65f6\uff0c\u4e8c\u7ea7\u79df\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String id = europaInfo.getId();
        Validate.notBlank((CharSequence)id, (String)"\u4fee\u6539\u65f6\uff0c\u5fc5\u987b\u4f20\u5165id\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        EuropaInfoEntity currentEuropaInfo = this.europaInfoRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)currentEuropaInfo), (String)"\u4fee\u6539\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u6570\u636e\u89c6\u56fe\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Boolean pageable = europaInfo.getPageable();
        Validate.notNull((Object)pageable, (String)"\u4fee\u6539\u65f6\uff0c\u662f\u5426\u5206\u9875\u7684\u8bbe\u7f6e\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String name = europaInfo.getName();
        Validate.notBlank((CharSequence)name, (String)"\u4fee\u6539\u65f6\uff0c\u6570\u636e\u89c6\u56fe\u7684\u4e2d\u6587\u540d\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String fileName = europaInfo.getFileName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = "";
        }
        if (StringUtils.isBlank((CharSequence)(relativeLocal = europaInfo.getRelativeLocal()))) {
            relativeLocal = "";
        }
        AbstractView abstractView = europaInfo.getView();
        Validate.notNull((Object)abstractView, (String)"\u9519\u8bef\u7684\u8be6\u7ec6\u6570\u636e\u89c6\u56fe\u67e5\u8be2\u6e90\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentEuropaInfo.setName(name);
        currentEuropaInfo.setFileName(fileName);
        currentEuropaInfo.setRelativeLocal(relativeLocal);
        currentEuropaInfo.setPageable(pageable);
        currentEuropaInfo.setModifyAccount(europaInfo.getModifyAccount());
        currentEuropaInfo.setModifyTime(europaInfo.getModifyTime());
        this.europaInfoRepository.save((Object)currentEuropaInfo);
        EuropaInfoMaintainStrategy matchedEuropaInfoMaintainStrategy = this.matchedEuropaInfoMaintainStrategy(europaInfo);
        Validate.notNull((Object)matchedEuropaInfoMaintainStrategy, (String)"\u9519\u8bef\u7684\u6570\u636e\u89c6\u56fe\u8fd0\u7ef4\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        matchedEuropaInfoMaintainStrategy.update(europaInfo);
        if (!CollectionUtils.isEmpty(this.europaInfoEventListeners)) {
            for (EuropaInfoEventListener europaInfoEventListener : this.europaInfoEventListeners) {
                europaInfoEventListener.onUpdate(europaInfo);
            }
        }
        return europaInfo;
    }

    @Transactional
    public void disable(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u9519\u8bef\u7684\u6570\u636e\u89c6\u56fe\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        EuropaInfoEntity currentEuropaInfo = this.europaInfoRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)currentEuropaInfo), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6570\u636e\u89c6\u56fe\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentEuropaInfo.setTstatus(0);
        this.europaInfoRepository.save((Object)currentEuropaInfo);
    }

    @Transactional
    public void enable(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u9519\u8bef\u7684\u6570\u636e\u89c6\u56fe\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        EuropaInfoEntity currentEuropaInfo = this.europaInfoRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)currentEuropaInfo), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6570\u636e\u89c6\u56fe\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentEuropaInfo.setTstatus(1);
        this.europaInfoRepository.save((Object)currentEuropaInfo);
    }

    @Transactional
    public void delete(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u9519\u8bef\u7684\u6570\u636e\u89c6\u56fe\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        EuropaInfoEntity currentEuropaInfo = this.europaInfoRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)currentEuropaInfo), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6570\u636e\u89c6\u56fe\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        EuropaInfoVo currentEuropaInfoVo = this.findByTenantCodeAndCode(currentEuropaInfo.getTenantCode(), currentEuropaInfo.getCode());
        EuropaInfoMaintainStrategy matchedEuropaInfoMaintainStrategy = this.matchedEuropaInfoMaintainStrategy(currentEuropaInfoVo);
        if (matchedEuropaInfoMaintainStrategy != null) {
            matchedEuropaInfoMaintainStrategy.delete(currentEuropaInfoVo);
        }
        this.europaInfoRepository.delete((Object)currentEuropaInfo);
    }

    public EuropaInfoVo findByTenantCodeAndCode(String tenantCode, String code) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, code})) {
            return null;
        }
        EuropaInfoEntity europaInfo = this.europaInfoRepository.findByTenantCodeAndCode(tenantCode, code);
        if (europaInfo == null) {
            return null;
        }
        EuropaInfoVo europaInfoVo = (EuropaInfoVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)europaInfo, EuropaInfoVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        EuropaInfoMaintainStrategy matchedEuropaInfoMaintainStrategy = this.matchedEuropaInfoMaintainStrategy(europaInfoVo);
        if (matchedEuropaInfoMaintainStrategy == null) {
            return europaInfoVo;
        }
        AbstractView abstractView = matchedEuropaInfoMaintainStrategy.request(europaInfo.getSourceType(), europaInfo.getCode());
        europaInfoVo.setView(abstractView);
        return europaInfoVo;
    }

    private EuropaInfoMaintainStrategy matchedEuropaInfoMaintainStrategy(EuropaInfoVo europaInfoVo) {
        EuropaInfoMaintainStrategy matchedEuropaInfoMaintainStrategy = null;
        for (EuropaInfoMaintainStrategy europaInfoMaintainStrategy : this.europaInfoMaintainStrategies) {
            if (!europaInfoMaintainStrategy.validate(europaInfoVo)) continue;
            matchedEuropaInfoMaintainStrategy = europaInfoMaintainStrategy;
            break;
        }
        return matchedEuropaInfoMaintainStrategy;
    }

    public Page<EuropaInfoVo> findByConditions(Pageable pageable, EuropaInfoDto europaInfoDto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        String tenantCode = TenantUtils.getTenantCode();
        europaInfoDto.setTenantCode(tenantCode);
        Page<EuropaInfoEntity> pageResults = this.europaInfoRepository.findByConditions(pageable, europaInfoDto);
        if (pageResults == null || pageResults.isEmpty()) {
            return null;
        }
        Collection europaInfoVos = this.nebulaToolkitService.copyCollectionByWhiteList(pageResults, EuropaInfoEntity.class, EuropaInfoVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new PageImpl((List)Lists.newArrayList((Iterable)europaInfoVos), pageable, pageResults.getTotalElements());
    }
}

