/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.local.service.internal;

import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.execute.RequestParameter;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.enums.ExecuteContentSqlTypeEnum;
import com.bizunited.nebula.europa.sdk.service.EuropaInfoVoService;
import com.bizunited.nebula.europa.sdk.service.ExecutionService;
import com.bizunited.nebula.europa.sdk.service.strategy.ExecutionStrategy;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.bizunited.nebula.europa.sdk.vo.ExecutionInfo;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="executionService")
public class ExecutionServiceImpl
implements ExecutionService {
    @Autowired
    private List<ExecutionStrategy> executionStrategies;
    @Autowired
    private EuropaInfoVoService europaInfoVoService;

    public ExecutionInfo execution(EuropaInfoVo europaInfo, Pageable pageable, RequestParameter requestParameter, ExecutionStrategy matchedExecutionStrategy) {
        Set orderParameters;
        if (matchedExecutionStrategy == null && !CollectionUtils.isEmpty(this.executionStrategies)) {
            for (ExecutionStrategy executionStrategy : this.executionStrategies) {
                if (!executionStrategy.isDefault()) continue;
                matchedExecutionStrategy = executionStrategy;
            }
        }
        Validate.notNull((Object)matchedExecutionStrategy, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u6267\u884c\u6570\u636e\u89c6\u56fe\u6267\u884c\u7b56\u7565\u4e14\u6574\u4e2a\u7cfb\u7edf\u6ca1\u6709\u8bbe\u5b9a\u9ed8\u8ba4\u7684\u6267\u884c\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        MetaData metaData = matchedExecutionStrategy.buildQueryMetaData(europaInfo, requestParameter);
        Validate.notNull((Object)metaData, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u6210\u529f\u6784\u5efa\u6570\u636e\u89c6\u56fe\u6700\u521d\u7684\u5143\u6570\u636e\u7ed3\u6784\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set executeParameters = matchedExecutionStrategy.buildExecuteParameters(metaData, europaInfo, requestParameter);
        if (CollectionUtils.isEmpty((Collection)executeParameters)) {
            executeParameters = Sets.newLinkedHashSet();
        }
        if (CollectionUtils.isEmpty((Collection)(orderParameters = matchedExecutionStrategy.buildOrderParameters(metaData, europaInfo, requestParameter)))) {
            orderParameters = Sets.newLinkedHashSet();
        }
        ExecuteContent executeContent = matchedExecutionStrategy.buildExecuteContent(metaData, europaInfo, requestParameter, executeParameters, orderParameters, ExecuteContentSqlTypeEnum.CONTENT_SQL.getStatus());
        ExecutionInfo executionInfo = new ExecutionInfo(europaInfo, metaData, executeContent);
        return executionInfo;
    }

    public ExecutionInfo executionOnlyCount(String tenantCode, String europaInfoCode, RequestParameter requestParameter, ExecutionStrategy matchedExecutionStrategy) {
        Validate.notBlank((CharSequence)europaInfoCode, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u4f20\u5165\u5bf9\u5e94\u7684\u6b27\u7f57\u5df4\u6570\u636e\u89c6\u56fe\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u4f20\u5165\u6307\u5b9a\u7684\u79df\u6237\u4fe1\u606f!!", (Object[])new Object[0]);
        EuropaInfoVo europaInfoVo = this.europaInfoVoService.findByTenantCodeAndCode(tenantCode, europaInfoCode);
        Validate.notNull((Object)europaInfoVo, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u6b27\u7f57\u5df4\u6570\u636e\u89c6\u56fe\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (matchedExecutionStrategy == null && !CollectionUtils.isEmpty(this.executionStrategies)) {
            for (ExecutionStrategy executionStrategy : this.executionStrategies) {
                if (!executionStrategy.isDefault()) continue;
                matchedExecutionStrategy = executionStrategy;
            }
        }
        Validate.notNull((Object)matchedExecutionStrategy, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u6267\u884c\u6570\u636e\u89c6\u56fe\u6267\u884c\u7b56\u7565\u4e14\u6574\u4e2a\u7cfb\u7edf\u6ca1\u6709\u8bbe\u5b9a\u9ed8\u8ba4\u7684\u6267\u884c\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        MetaData metaData = matchedExecutionStrategy.buildQueryMetaData(europaInfoVo, requestParameter);
        Validate.notNull((Object)metaData, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u6210\u529f\u6784\u5efa\u6570\u636e\u89c6\u56fe\u6700\u521d\u7684\u5143\u6570\u636e\u7ed3\u6784\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set executeParameters = matchedExecutionStrategy.buildExecuteParameters(metaData, europaInfoVo, requestParameter);
        if (CollectionUtils.isEmpty((Collection)executeParameters)) {
            executeParameters = Sets.newLinkedHashSet();
        }
        ExecuteContent executeContent = matchedExecutionStrategy.buildExecuteContent(metaData, europaInfoVo, requestParameter, executeParameters, null, ExecuteContentSqlTypeEnum.COUNT_SQL.getStatus());
        ExecutionInfo executionInfo = new ExecutionInfo(europaInfoVo, metaData, executeContent);
        return executionInfo;
    }

    public ExecutionInfo executionStatistic(EuropaInfoVo europaInfo, RequestParameter requestParameter, ExecutionStrategy matchedExecutionStrategy) {
        Set orderParameters;
        if (matchedExecutionStrategy == null && !CollectionUtils.isEmpty(this.executionStrategies)) {
            for (ExecutionStrategy executionStrategy : this.executionStrategies) {
                if (!executionStrategy.isDefault()) continue;
                matchedExecutionStrategy = executionStrategy;
            }
        }
        Validate.notNull((Object)matchedExecutionStrategy, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u6267\u884c\u6570\u636e\u89c6\u56fe\u6267\u884c\u7b56\u7565\u4e14\u6574\u4e2a\u7cfb\u7edf\u6ca1\u6709\u8bbe\u5b9a\u9ed8\u8ba4\u7684\u6267\u884c\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        MetaData metaData = matchedExecutionStrategy.buildQueryMetaData(europaInfo, requestParameter);
        Validate.notNull((Object)metaData, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u6210\u529f\u6784\u5efa\u6570\u636e\u89c6\u56fe\u6700\u521d\u7684\u5143\u6570\u636e\u7ed3\u6784\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set executeParameters = matchedExecutionStrategy.buildExecuteParameters(metaData, europaInfo, requestParameter);
        if (CollectionUtils.isEmpty((Collection)executeParameters)) {
            executeParameters = Sets.newLinkedHashSet();
        }
        if (CollectionUtils.isEmpty((Collection)(orderParameters = matchedExecutionStrategy.buildOrderParameters(metaData, europaInfo, requestParameter)))) {
            orderParameters = Sets.newLinkedHashSet();
        }
        ExecuteContent executeContent = matchedExecutionStrategy.buildExecuteContent(metaData, europaInfo, requestParameter, executeParameters, orderParameters, ExecuteContentSqlTypeEnum.STATISTIC_SQL.getStatus());
        return new ExecutionInfo(europaInfo, metaData, executeContent);
    }

    public ExecutionInfo execution(String tenantCode, String europaInfoCode, Pageable pageable, RequestParameter requestParameter, ExecutionStrategy matchedExecutionStrategy) {
        Validate.notBlank((CharSequence)europaInfoCode, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u4f20\u5165\u5bf9\u5e94\u7684\u6b27\u7f57\u5df4\u6570\u636e\u89c6\u56fe\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u4f20\u5165\u6307\u5b9a\u7684\u79df\u6237\u4fe1\u606f!!", (Object[])new Object[0]);
        EuropaInfoVo europaInfoVo = this.europaInfoVoService.findByTenantCodeAndCode(tenantCode, europaInfoCode);
        Validate.notNull((Object)europaInfoVo, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u6b27\u7f57\u5df4\u6570\u636e\u89c6\u56fe\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return this.execution(europaInfoVo, pageable, requestParameter, matchedExecutionStrategy);
    }
}

