/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.local.service.internal;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.local.entity.EuropaInfoEntity;
import com.bizunited.nebula.europa.local.entity.PersonalizationTemplateEntity;
import com.bizunited.nebula.europa.local.repository.EuropaInfoRepository;
import com.bizunited.nebula.europa.local.repository.PersonalizationTemplateRepository;
import com.bizunited.nebula.europa.sdk.event.PersonalizationTemplateEventListener;
import com.bizunited.nebula.europa.sdk.service.EuropaInfoVoService;
import com.bizunited.nebula.europa.sdk.service.PersonalizationTemplateVoService;
import com.bizunited.nebula.europa.sdk.service.strategy.PersonalizationTemplateStrategy;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.bizunited.nebula.europa.sdk.vo.PersonalizationTemplateVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

@Service
public class PersonalizationTemplateVoServiceImpl
implements PersonalizationTemplateVoService {
    @Autowired
    private PersonalizationTemplateRepository personalizationTemplateRepository;
    @Autowired
    private EuropaInfoRepository europaInfoRepository;
    @Autowired
    private EuropaInfoVoService europaInfoVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private Redisson redisson;
    private Map<String, PersonalizationTemplateVo> cache = new ConcurrentReferenceHashMap();
    @Autowired(required=false)
    @Lazy
    private List<PersonalizationTemplateStrategy> personalizationTemplateStrategies;
    @Autowired(required=false)
    @Lazy
    private List<PersonalizationTemplateEventListener> personalizationTemplateEventListeners;
    private static Map<String, ReentrantReadWriteLock> europaLockMapping = Maps.newConcurrentMap();

    @Transactional
    public void create(PersonalizationTemplateVo personalizationTemplate) {
        EuropaInfoVo europaInfoVo = this.validate(personalizationTemplate, "\u521b\u5efa\u4e2a\u6027\u5316\u6837\u5f0f\u65f6");
        String tenantCode = personalizationTemplate.getTenantCode();
        String europaInfoCode = personalizationTemplate.getEuropaInfoCode();
        Map mathedMapping = personalizationTemplate.getMathedMapping();
        personalizationTemplate.setId(null);
        String code = personalizationTemplate.getCode();
        PersonalizationTemplateVo existPersonalizationTemplate = this.findDetailsByCode(code);
        Validate.isTrue((existPersonalizationTemplate == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u4e2a\u6027\u5316\u6837\u5f0f\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u88ab\u4f7f\u7528\u7684\u4e2a\u6027\u5316\u6837\u5f0f\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.notifyCacheRefresh(tenantCode, europaInfoCode);
        PersonalizationTemplateEntity personalizationTemplateEntity = (PersonalizationTemplateEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)personalizationTemplate, PersonalizationTemplateEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        EuropaInfoEntity europaInfoEntity = new EuropaInfoEntity();
        europaInfoEntity.setId(europaInfoVo.getId());
        personalizationTemplateEntity.setEuropaInfo(europaInfoEntity);
        this.personalizationTemplateRepository.save((Object)personalizationTemplateEntity);
        personalizationTemplate.setId(personalizationTemplateEntity.getId());
        boolean matched = false;
        block0: for (PersonalizationTemplateStrategy personalizationTemplateStrategy : this.personalizationTemplateStrategies) {
            for (Map.Entry entryItem : mathedMapping.entrySet()) {
                String key = (String)entryItem.getKey();
                String value = (String)entryItem.getValue();
                if (!StringUtils.equals((CharSequence)personalizationTemplateStrategy.getName(), (CharSequence)key)) continue;
                personalizationTemplateStrategy.onMappingCreate(europaInfoVo, personalizationTemplate, key, value);
                matched = true;
                continue block0;
            }
        }
        Validate.isTrue((boolean)matched, (String)"\u521b\u5efa\u65f6\uff0c\u672a\u627e\u5230\u4efb\u4f55\u5408\u9002\u7684\u4e2a\u6027\u5316\u8bbe\u7f6e\u7ef4\u5ea6\u5339\u914d\u7b56\u7565PersonalizationTemplateStrategy\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.personalizationTemplateEventListeners)) {
            for (PersonalizationTemplateEventListener personalizationTemplateEventListener : this.personalizationTemplateEventListeners) {
                personalizationTemplateEventListener.onCreate(personalizationTemplate);
            }
        }
    }

    private EuropaInfoVo validate(PersonalizationTemplateVo personalizationTemplate, String onTime) {
        Validate.isTrue((!CollectionUtils.isEmpty(this.personalizationTemplateStrategies) ? 1 : 0) != 0, (String)(onTime + "\uff0c\u81f3\u5c11\u9700\u8981\u6307\u5b9a\u4e00\u79cd\u4e1a\u52a1\u6269\u5c55\u7b56\u7565\uff0c\u8bf7\u53c2\u89c1PersonalizationTemplateStrategy\u8bf4\u660e"), (Object[])new Object[0]);
        Validate.notNull((Object)personalizationTemplate, (String)(onTime + "\uff0c\u521b\u5efa\u4e2a\u6027\u5316\u6837\u5f0f\u65f6\uff0c\u6837\u5f0f\u57fa\u672c\u4fe1\u606f\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        String europaInfoCode = personalizationTemplate.getEuropaInfoCode();
        String fileName = personalizationTemplate.getFileName();
        String relativeLocal = personalizationTemplate.getRelativeLocal();
        String tenantCode = personalizationTemplate.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
            personalizationTemplate.setTenantCode(tenantCode);
        }
        String code = personalizationTemplate.getCode();
        Map mathedMapping = personalizationTemplate.getMathedMapping();
        Validate.notBlank((CharSequence)europaInfoCode, (String)(onTime + "\uff0c\u5fc5\u987b\u6307\u5b9a\u6570\u636e\u89c6\u56fe\u57fa\u672c\u4fe1\u606f\u4e1a\u52a1\u7f16\u53f7!!"), (Object[])new Object[0]);
        EuropaInfoVo europaInfoVo = this.europaInfoVoService.findByTenantCodeAndCode(tenantCode, europaInfoCode);
        Validate.notNull((Object)europaInfoVo, (String)(onTime + "\uff0c\u672a\u627e\u5230\u6307\u5b9a\u6570\u636e\u89c6\u56fe\u57fa\u672c\u4fe1\u606f!!"), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileName, (String)(onTime + "\uff0c\u6837\u5f0f\u6587\u4ef6\u540d\u4fe1\u606f\u5fc5\u987b\u586b\u5199"), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)relativeLocal, (String)(onTime + "\uff0c\u6837\u5f0f\u6587\u4ef6\u8def\u5f84\u4fe1\u606f\u5fc5\u987b\u586b\u5199"), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)code, (String)(onTime + "\uff0c\u6837\u5f0f\u6587\u4ef6\u4fe1\u606f\u7684\u4e1a\u52a1\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!"), (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Map)mathedMapping) ? 1 : 0) != 0, (String)(onTime + "\uff0c\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u6837\u5f0f\u4fe1\u606f\u5339\u914d\u7684\u4e1a\u52a1\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        return europaInfoVo;
    }

    @Transactional
    public void update(PersonalizationTemplateVo personalizationTemplate) {
        EuropaInfoVo europaInfoVo = this.validate(personalizationTemplate, "\u4fee\u6539\u4e2a\u6027\u5316\u6837\u5f0f\u65f6");
        String tenantCode = personalizationTemplate.getTenantCode();
        String europaInfoCode = personalizationTemplate.getEuropaInfoCode();
        Map mathedMapping = personalizationTemplate.getMathedMapping();
        String code = personalizationTemplate.getCode();
        String id = personalizationTemplate.getId();
        Validate.notBlank((CharSequence)id, (String)"\u4fee\u6539\u4e2a\u6027\u5316\u6837\u5f0f\u8bbe\u5b9a\u65f6\uff0c\u539f\u6709\u4e2a\u6027\u5316\u6837\u5f0f\u7684id\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        PersonalizationTemplateEntity oldPersonalizationTemplateEntity = this.personalizationTemplateRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)oldPersonalizationTemplateEntity), (String)"\u4fee\u6539\u4e2a\u6027\u5316\u6837\u5f0f\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u4e2a\u6027\u5316\u6837\u5f0f\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)oldPersonalizationTemplateEntity.getCode(), (CharSequence)code), (String)"\u4fee\u6539\u4e2a\u6027\u5316\u6837\u5f0f\u65f6\uff0c\u5176\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\u4e0d\u5141\u8bb8\u4fee\u6539", (Object[])new Object[0]);
        PersonalizationTemplateVo oldPersonalizationTemplate = this.findDetailsByCode(code);
        this.notifyCacheRefresh(tenantCode, europaInfoCode);
        oldPersonalizationTemplateEntity.setFileName(personalizationTemplate.getFileName());
        oldPersonalizationTemplateEntity.setRelativeLocal(personalizationTemplate.getRelativeLocal());
        this.personalizationTemplateRepository.save((Object)oldPersonalizationTemplateEntity);
        this.updateForMapping(mathedMapping, personalizationTemplate, oldPersonalizationTemplate, europaInfoVo);
        if (!CollectionUtils.isEmpty(this.personalizationTemplateEventListeners)) {
            for (PersonalizationTemplateEventListener personalizationTemplateEventListener : this.personalizationTemplateEventListeners) {
                personalizationTemplateEventListener.onUpdate(personalizationTemplate);
            }
        }
    }

    private void updateForMapping(Map<String, String> mathedMapping, PersonalizationTemplateVo personalizationTemplate, PersonalizationTemplateVo oldPersonalizationTemplate, EuropaInfoVo europaInfoVo) {
        Sets.SetView mustUpdateKeys;
        Sets.SetView mustDeleteKeys;
        Set oldMapping;
        LinkedHashMap mustCreateMapping = Maps.newLinkedHashMap();
        LinkedHashMap mustUpdateMapping = Maps.newLinkedHashMap();
        LinkedHashMap mustDeleteMapping = Maps.newLinkedHashMap();
        Set<String> currentMapping = mathedMapping.keySet();
        Sets.SetView mustCreateKeys = Sets.difference(currentMapping, oldMapping = oldPersonalizationTemplate.getMathedMapping().keySet());
        if (!CollectionUtils.isEmpty((Collection)mustCreateKeys)) {
            for (String mustCreateKey : mustCreateKeys) {
                mustCreateMapping.put(mustCreateKey, mathedMapping.get(mustCreateKey));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(mustDeleteKeys = Sets.difference(oldMapping, currentMapping)))) {
            for (String mustDeleteKey : mustDeleteKeys) {
                mustDeleteMapping.put(mustDeleteKey, oldPersonalizationTemplate.getMathedMapping().get(mustDeleteKey));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(mustUpdateKeys = Sets.intersection(currentMapping, oldMapping)))) {
            for (String mustUpdateKey : mustUpdateKeys) {
                mustUpdateMapping.put(mustUpdateKey, mathedMapping.get(mustUpdateKey));
            }
        }
        for (PersonalizationTemplateStrategy personalizationTemplateStrategy : this.personalizationTemplateStrategies) {
            String name = personalizationTemplateStrategy.getName();
            for (Map.Entry mustDeleteItem : mustDeleteMapping.entrySet()) {
                String mustDeleteItemKey = (String)mustDeleteItem.getKey();
                String mustDeleteItemValue = (String)mustDeleteItem.getValue();
                if (!StringUtils.equals((CharSequence)mustDeleteItemKey, (CharSequence)name)) continue;
                personalizationTemplateStrategy.onMappingDelete(europaInfoVo, personalizationTemplate, mustDeleteItemKey, mustDeleteItemValue);
            }
            for (Map.Entry mustCreateItem : mustCreateMapping.entrySet()) {
                String mustCreateItemKey = (String)mustCreateItem.getKey();
                String mustCreateItemValue = (String)mustCreateItem.getValue();
                if (!StringUtils.equals((CharSequence)mustCreateItemKey, (CharSequence)name)) continue;
                personalizationTemplateStrategy.onMappingCreate(europaInfoVo, personalizationTemplate, mustCreateItemKey, mustCreateItemValue);
            }
            for (Map.Entry mustUpdateItem : mustUpdateMapping.entrySet()) {
                String mustUpdateItemKey = (String)mustUpdateItem.getKey();
                String mustUpdateItemValue = (String)mustUpdateItem.getValue();
                if (!StringUtils.equals((CharSequence)mustUpdateItemKey, (CharSequence)name)) continue;
                personalizationTemplateStrategy.onMappingModify(europaInfoVo, personalizationTemplate, mustUpdateItemKey, mustUpdateItemValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonalizationTemplateVo findEffectiveByCurrentUser(String europaInfoCode) {
        if (StringUtils.isBlank((CharSequence)europaInfoCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        String account = this.findCurrentAccount();
        if (StringUtils.isBlank((CharSequence)account)) {
            return this.findDefaultByEuropaInfoCode(tenantCode, europaInfoCode);
        }
        String key = StringUtils.join((Object[])new String[]{tenantCode, "_", europaInfoCode, "_", account});
        ReentrantReadWriteLock.ReadLock readLock = this.getReadLockByEuropaCode(tenantCode, europaInfoCode);
        try {
            readLock.lock();
            PersonalizationTemplateVo currentPersonalizationTemplate = this.cache.get(key);
            if (currentPersonalizationTemplate != null) {
                PersonalizationTemplateVo personalizationTemplateVo = currentPersonalizationTemplate;
                return personalizationTemplateVo;
            }
        }
        finally {
            readLock.unlock();
        }
        Set<PersonalizationTemplateEntity> personalizationTemplates = this.personalizationTemplateRepository.findByTenantCodeAndEuropaInfoCode(tenantCode, europaInfoCode);
        if (CollectionUtils.isEmpty(personalizationTemplates)) {
            return this.findDefaultByEuropaInfoCode(tenantCode, europaInfoCode);
        }
        LinkedHashSet personalizationTemplateVos = Sets.newLinkedHashSet();
        for (PersonalizationTemplateEntity personalizationTemplate : personalizationTemplates) {
            PersonalizationTemplateVo personalizationTemplateVo = (PersonalizationTemplateVo)this.nebulaToolkitService.copyObjectByBlankList((Object)personalizationTemplate, PersonalizationTemplateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            personalizationTemplateVo.setEuropaInfoCode(personalizationTemplate.getEuropaInfo().getCode());
            personalizationTemplateVos.add(personalizationTemplateVo);
        }
        for (PersonalizationTemplateStrategy personalizationTemplateStrategy : this.personalizationTemplateStrategies) {
            for (PersonalizationTemplateVo personalizationTemplateVo : personalizationTemplateVos) {
                String mappingKey = personalizationTemplateStrategy.getName();
                String value = null;
                value = personalizationTemplateStrategy.onRequestByAccount(personalizationTemplateVo, tenantCode, account, mappingKey);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                LinkedHashMap currentMathedMapping = Maps.newLinkedHashMap();
                currentMathedMapping.put(mappingKey, value);
                personalizationTemplateVo.setMathedMapping((Map)currentMathedMapping);
                ReentrantReadWriteLock.WriteLock writeLock = this.getWriteLockByEuropaCode(tenantCode, europaInfoCode);
                try {
                    writeLock.lock();
                    this.cache.put(key, personalizationTemplateVo);
                }
                finally {
                    writeLock.unlock();
                }
                return personalizationTemplateVo;
            }
        }
        return this.findDefaultByEuropaInfoCode(tenantCode, europaInfoCode);
    }

    private PersonalizationTemplateVo findDefaultByEuropaInfoCode(String tenantCode, String europaInfoCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, europaInfoCode})) {
            return null;
        }
        EuropaInfoEntity europaInfo = this.europaInfoRepository.findByTenantCodeAndCode(tenantCode, europaInfoCode);
        if (europaInfo == null) {
            return null;
        }
        PersonalizationTemplateVo personalizationTemplate = new PersonalizationTemplateVo();
        personalizationTemplate.setCode("default");
        personalizationTemplate.setEuropaInfoCode(europaInfoCode);
        personalizationTemplate.setFileName(europaInfo.getFileName());
        personalizationTemplate.setRelativeLocal(europaInfo.getRelativeLocal());
        personalizationTemplate.setTenantCode(tenantCode);
        return personalizationTemplate;
    }

    public PersonalizationTemplateVo findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        PersonalizationTemplateEntity personalizationTemplate = this.personalizationTemplateRepository.findByTenantCodeAndCode(tenantCode, code);
        if (personalizationTemplate == null) {
            return null;
        }
        PersonalizationTemplateVo personalizationTemplateVo = (PersonalizationTemplateVo)this.nebulaToolkitService.copyObjectByBlankList((Object)personalizationTemplate, PersonalizationTemplateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        personalizationTemplateVo.setEuropaInfoCode(personalizationTemplate.getEuropaInfo().getCode());
        LinkedHashMap currentMathedMapping = Maps.newLinkedHashMap();
        for (PersonalizationTemplateStrategy personalizationTemplateStrategy : this.personalizationTemplateStrategies) {
            String mappingKey;
            String value = personalizationTemplateStrategy.onRequest(personalizationTemplateVo, tenantCode, mappingKey = personalizationTemplateStrategy.getName());
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            currentMathedMapping.put(mappingKey, value);
        }
        personalizationTemplateVo.setMathedMapping((Map)currentMathedMapping);
        return personalizationTemplateVo;
    }

    public Set<PersonalizationTemplateVo> findDetailsByEuropaInfoCode(String europaInfoCode) {
        if (StringUtils.isBlank((CharSequence)europaInfoCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        Set<PersonalizationTemplateEntity> personalizationTemplates = this.personalizationTemplateRepository.findByTenantCodeAndEuropaInfoCode(tenantCode, europaInfoCode);
        if (CollectionUtils.isEmpty(personalizationTemplates)) {
            return null;
        }
        LinkedHashSet personalizationTemplateVos = Sets.newLinkedHashSet();
        for (PersonalizationTemplateEntity personalizationTemplate : personalizationTemplates) {
            PersonalizationTemplateVo personalizationTemplateVo = (PersonalizationTemplateVo)this.nebulaToolkitService.copyObjectByBlankList((Object)personalizationTemplate, PersonalizationTemplateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            personalizationTemplateVo.setEuropaInfoCode(personalizationTemplate.getEuropaInfo().getCode());
            personalizationTemplateVos.add(personalizationTemplateVo);
        }
        for (PersonalizationTemplateVo personalizationTemplateVo : personalizationTemplateVos) {
            LinkedHashMap currentMathedMapping = Maps.newLinkedHashMap();
            for (PersonalizationTemplateStrategy personalizationTemplateStrategy : this.personalizationTemplateStrategies) {
                String mappingKey;
                String value = personalizationTemplateStrategy.onRequest(personalizationTemplateVo, tenantCode, mappingKey = personalizationTemplateStrategy.getName());
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                currentMathedMapping.put(mappingKey, value);
            }
            personalizationTemplateVo.setMathedMapping((Map)currentMathedMapping);
        }
        return personalizationTemplateVos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock.WriteLock getWriteLockByEuropaCode(String tenantCode, String europaCode) {
        String key = StringUtils.join((Object[])new String[]{tenantCode, "_", europaCode});
        while (europaLockMapping.get(key) == null) {
            Map<String, ReentrantReadWriteLock> map = europaLockMapping;
            synchronized (map) {
                if (europaLockMapping.get(key) == null) {
                    europaLockMapping.put(key, new ReentrantReadWriteLock());
                }
            }
        }
        ReentrantReadWriteLock lock = europaLockMapping.get(key);
        return lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock.ReadLock getReadLockByEuropaCode(String tenantCode, String europaCode) {
        String key = StringUtils.join((Object[])new String[]{tenantCode, "_", europaCode});
        while (europaLockMapping.get(key) == null) {
            Map<String, ReentrantReadWriteLock> map = europaLockMapping;
            synchronized (map) {
                if (europaLockMapping.get(key) == null) {
                    europaLockMapping.put(key, new ReentrantReadWriteLock());
                }
            }
        }
        ReentrantReadWriteLock lock = europaLockMapping.get(key);
        return lock.readLock();
    }

    private String findCurrentAccount() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext == null) {
            return null;
        }
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            return null;
        }
        String account = authentication.getName();
        return account;
    }

    public void notifyCacheRefresh(String tenantCode, String europaInfoCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, europaInfoCode})) {
            return;
        }
        RTopic topic = this.redisson.getTopic("_EUROPAINFO_CODE_NOTIFY");
        topic.publish((Object)StringUtils.join((Object[])new String[]{tenantCode, "|", europaInfoCode}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(String tenantCode, String europaInfoCode) {
        Validate.notBlank((CharSequence)tenantCode, (String)"\u6e05\u7406\u6570\u636e\u89c6\u56fe\u4e2a\u6027\u6837\u5f0f\u7f13\u5b58\u65f6\uff0c\u4e8c\u7ea7\u79df\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)europaInfoCode, (String)"\u6e05\u7406\u6570\u636e\u89c6\u56fe\u4e2a\u6027\u6837\u5f0f\u7f13\u5b58\u65f6\uff0c\u6570\u636e\u89c6\u56fe\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String key = StringUtils.join((Object[])new String[]{tenantCode, "_", europaInfoCode});
        ReentrantReadWriteLock.WriteLock writeLock = this.getWriteLockByEuropaCode(tenantCode, europaInfoCode);
        try {
            writeLock.lock();
            if (CollectionUtils.isEmpty(this.cache)) {
                return;
            }
            Set<String> keys = this.cache.keySet();
            for (String keyItem : keys) {
                if (StringUtils.indexOf((CharSequence)keyItem, (CharSequence)key) == -1) continue;
                this.cache.remove(keyItem);
            }
        }
        finally {
            writeLock.unlock();
        }
    }
}

