/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.sdk.context.matedata;

import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaDataField;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class AbstractMetaData
implements MetaData {
    private static final long serialVersionUID = -611051251540208953L;
    private List<MetaDataField> metaDataFields = Lists.newArrayList();
    private String sourceType;

    public AbstractMetaData(String sourceType) {
        Validate.notBlank((CharSequence)sourceType, (String)"\u5143\u6570\u636e\u5fc5\u987b\u8bbe\u5b9a\u6765\u6e90\u7c7b\u578b", (Object[])new Object[0]);
        this.sourceType = sourceType;
    }

    @Override
    public int getFieldCount() {
        return this.metaDataFields.size();
    }

    @Override
    public MetaDataField getMetaDataField(int index) {
        if (index < 0) {
            return null;
        }
        return this.metaDataFields.get(index);
    }

    @Override
    public MetaDataField getMetaDataField(String fieldName) {
        for (MetaDataField queryField : this.metaDataFields) {
            String currentFieldName = queryField.getFieldName();
            if (!StringUtils.equals((CharSequence)currentFieldName, (CharSequence)fieldName)) continue;
            return queryField;
        }
        return null;
    }

    @Override
    public boolean exsitMetaDataField(String fieldName) {
        for (MetaDataField metaDataField : this.metaDataFields) {
            String currentFieldName = metaDataField.getFieldName();
            if (!StringUtils.equals((CharSequence)currentFieldName, (CharSequence)fieldName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMetaDataField(int index, MetaDataField metaDataField) {
        Validate.notNull((Object)metaDataField, (String)"\u8bbe\u5b9a\u5143\u6570\u636e\u5b57\u6bb5\u7ed3\u6784\u65f6\uff0c\u5b57\u6bb5\u57fa\u672c\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        if (index >= this.metaDataFields.size()) {
            return;
        }
        this.metaDataFields.set(index, metaDataField);
    }

    @Override
    public void addMetaDataField(int index, MetaDataField queryField) {
        Validate.notNull((Object)queryField, (String)"\u6dfb\u52a0\u5143\u6570\u636e\u5b57\u6bb5\u7ed3\u6784\u65f6\uff0c\u5b57\u6bb5\u57fa\u672c\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        if (index >= this.metaDataFields.size()) {
            return;
        }
        this.metaDataFields.add(index, queryField);
    }

    @Override
    public void addMetaDataField(MetaDataField queryField) {
        Validate.notNull((Object)queryField, (String)"\u6dfb\u52a0\u5143\u6570\u636e\u5b57\u6bb5\u7ed3\u6784\u65f6\uff0c\u5b57\u6bb5\u57fa\u672c\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        this.metaDataFields.add(queryField);
    }

    @Override
    public String getSourceType() {
        return this.sourceType;
    }

    public List<MetaDataField> getMetaDataFields() {
        return this.metaDataFields;
    }
}

