/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.event.local.config;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NacosConfig {
    @Value(value="${nacos.server-addr:}")
    private String serverAddr;
    @Value(value="${nacos._namespace:}")
    private String namespace;
    @Value(value="${nacos.username:}")
    private String username;
    @Value(value="${nacos.password:}")
    private String password;
    @Value(value="${nacos.group:}")
    private String group;
    @Value(value="${nacos.clusterName:}")
    private String clusterName;
    @Value(value="${nacos.accessKey:}")
    private String accessKey;
    @Value(value="${nacos.secretKey:}")
    private String secretKey;

    @Bean
    @ConditionalOnMissingBean
    public ConfigService getConfigService() throws NacosException {
        Properties properties = new Properties();
        properties.put("serverAddr", this.serverAddr);
        if (StringUtils.isNotBlank((CharSequence)this.namespace)) {
            properties.put("namespace", this.namespace);
        }
        if (StringUtils.isNotBlank((CharSequence)this.username)) {
            properties.put("username", this.username);
        }
        if (StringUtils.isNotBlank((CharSequence)this.password)) {
            properties.put("password", this.password);
        }
        if (StringUtils.isNotBlank((CharSequence)this.group)) {
            properties.put("group", this.group);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clusterName)) {
            properties.put("clusterName", this.clusterName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.accessKey)) {
            properties.put("accessKey", this.accessKey);
        }
        if (StringUtils.isNotBlank((CharSequence)this.secretKey)) {
            properties.put("secretKey", this.secretKey);
        }
        return NacosFactory.createConfigService((Properties)properties);
    }
}

