/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.event.local.service.internal;

import com.bizunited.nebula.event.sdk.model.EventProvider;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;
import com.bizunited.nebula.event.sdk.service.NebulaEventContainerManagement;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventConsumerChain;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Scope(value="prototype")
@Lazy
public class LocalNebulaNetEventConsumer
implements NebulaNetEventConsumer {
    private final EventProvider eventProvider;
    @Autowired
    private NebulaEventContainerManagement nebulaEventContainerManagement;

    public LocalNebulaNetEventConsumer(EventProvider eventProvider) {
        this.eventProvider = eventProvider;
    }

    public void execute(NebulaEventDto nebulaEventDto, NebulaNetEventConsumerChain nebulaNetEventConsumerChain) {
        String name = this.eventProvider.getDataId();
        String methodName = this.eventProvider.getMethodName();
        Set eventList = this.nebulaEventContainerManagement.getEventImplByClassName(name);
        if (CollectionUtils.isEmpty((Collection)eventList)) {
            return;
        }
        block2: for (NebulaEvent nebulaEvent : eventList) {
            Class<?> eventClass = nebulaEvent.getClass();
            Object[] methods = eventClass.getMethods();
            if (ArrayUtils.isEmpty((Object[])methods)) continue;
            for (Object method : methods) {
                if (!((Method)method).getName().equals(methodName)) continue;
                try {
                    ((Method)method).invoke((Object)nebulaEvent, nebulaEventDto);
                    continue block2;
                }
                catch (Exception e) {
                    String message = ((InvocationTargetException)e).getTargetException().getMessage();
                    throw new RuntimeException(message, e);
                }
            }
        }
        nebulaNetEventConsumerChain.execute(nebulaEventDto);
    }
}

