/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.event.local.service.internal;

import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.event.local.service.internal.DirectNebulaNetEventConsumer;
import com.bizunited.nebula.event.local.service.internal.NebulaNetEventConsumerChainImpl;
import com.bizunited.nebula.event.local.service.internal.NebulaNetEventConsumerChainWithNoBreakImpl;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventProvider;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventArrangement;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventConsumerChain;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventContainerManagement;
import com.bizunited.nebula.event.sdk.service.NebulaResponseEventConsumer;
import com.bizunited.nebula.event.sdk.util.LambdaUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NebulaNetEventClientImpl
implements NebulaNetEventClient {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private NebulaNetEventContainerManagement nebulaNetEventContainerManagement;
    @Autowired(required=false)
    private NebulaNetEventArrangement nebulaNetEventArrangement;

    public void publish(NebulaEventDto nebulaEventDto, Class<? extends NebulaEvent> event, SerializableBiConsumer<? extends NebulaEvent, ? extends NebulaEventDto> func) {
        this.publish(nebulaEventDto, event, func, NebulaNetEventConsumerChainImpl.class);
    }

    public void publishWithNoBreak(NebulaEventDto nebulaEventDto, Class<? extends NebulaEvent> event, SerializableBiConsumer<? extends NebulaEvent, ? extends NebulaEventDto> func) {
        this.publish(nebulaEventDto, event, func, NebulaNetEventConsumerChainWithNoBreakImpl.class);
    }

    public void publishToService(NebulaEventDto nebulaEventDto, Class<? extends NebulaEvent> event, SerializableBiConsumer<? extends NebulaEvent, ? extends NebulaEventDto> func) {
        String methodName = this.getMethodName(func);
        List eventProviders = this.nebulaNetEventContainerManagement.getEventProvider(event);
        eventProviders = (List)ObjectUtils.defaultIfNull((Object)eventProviders, (Object)Lists.newArrayList());
        if (CollectionUtils.isEmpty(eventProviders = eventProviders.stream().filter(provider -> Objects.equals(provider.getServiceName(), nebulaEventDto.getAppName())).collect(Collectors.toList()))) {
            throw new IllegalArgumentException("\u4e8b\u4ef6\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u5b9e\u73b0\u7cfb\u7edf,\u8bf7\u68c0\u67e5\u4e1a\u52a1\u7cfb\u7edf\u662f\u5426\u6b63\u5e38!");
        }
        for (EventProvider eventProvider : eventProviders) {
            eventProvider.setMethodName(methodName);
        }
        List nebulaNetEventConsumers = this.nebulaNetEventArrangement.arrangeEvent(eventProviders);
        this.publish(nebulaEventDto, nebulaNetEventConsumers, NebulaNetEventConsumerChainImpl.class);
    }

    public void publish(NebulaEventDto nebulaEventDto, Class<? extends NebulaEvent> event, SerializableBiConsumer<? extends NebulaEvent, ? extends NebulaEventDto> func, Class<? extends NebulaNetEventConsumerChain> chainClass) {
        String methodName = this.getMethodName(func);
        List eventProviders = this.nebulaNetEventContainerManagement.getEventProvider(event);
        if (CollectionUtils.isEmpty((Collection)eventProviders)) {
            return;
        }
        for (EventProvider eventProvider : eventProviders) {
            eventProvider.setMethodName(methodName);
        }
        List nebulaNetEventConsumers = this.nebulaNetEventArrangement.arrangeEvent(eventProviders);
        this.publish(nebulaEventDto, nebulaNetEventConsumers, chainClass);
    }

    public void publish(NebulaEventDto nebulaEventDto, List<NebulaNetEventConsumer> nebulaNetEventConsumers, Class<? extends NebulaNetEventConsumerChain> chainClass) {
        NebulaNetEventConsumerChain chain = (NebulaNetEventConsumerChain)this.applicationContext.getBean(chainClass, new Object[]{nebulaNetEventConsumers});
        chain.execute(nebulaEventDto);
    }

    public void publish(NebulaEventDto nebulaEventDto, List<NebulaNetEventConsumer> nebulaNetEventConsumers) {
        NebulaNetEventConsumerChain chain = (NebulaNetEventConsumerChain)this.applicationContext.getBean(NebulaNetEventConsumerChainImpl.class, new Object[]{nebulaNetEventConsumers});
        chain.execute(nebulaEventDto);
    }

    public EventResponse directPublish(NebulaEventDto nebulaEventDto, Class<? extends NebulaEvent> event, SerializableBiConsumer<? extends NebulaEvent, ? extends NebulaEventDto> func) {
        String methodName = this.getMethodName(func);
        List eventProviders = this.nebulaNetEventContainerManagement.getEventProvider(event);
        if (CollectionUtils.isEmpty((Collection)eventProviders)) {
            return null;
        }
        String serviceName = null;
        for (EventProvider provider : eventProviders) {
            String service = provider.getServiceName();
            if (StringUtils.isBlank(serviceName)) {
                serviceName = service;
                continue;
            }
            if (serviceName.equals(service)) continue;
            throw new IllegalArgumentException("\u6b64\u4e8b\u4ef6\u65b9\u6cd5\u53ea\u80fd\u8c03\u7528\u4e00\u4e2a\u4e8b\u4ef6\u5b9e\u73b0");
        }
        EventProvider eventProvider = (EventProvider)eventProviders.get(0);
        eventProvider.setMethodName(methodName);
        NebulaResponseEventConsumer consumer = (NebulaResponseEventConsumer)this.applicationContext.getBean(DirectNebulaNetEventConsumer.class, new Object[]{eventProvider});
        consumer.execute(nebulaEventDto, null);
        return consumer.getEventResponse();
    }

    public EventResponse publishToApplication(NebulaEventDto nebulaEventDto, Class<? extends NebulaEvent> event, SerializableBiConsumer<? extends NebulaEvent, ? extends NebulaEventDto> func) {
        String methodName = this.getMethodName(func);
        List eventProviders = this.nebulaNetEventContainerManagement.getEventProvider(event);
        if (CollectionUtils.isEmpty((Collection)eventProviders)) {
            return null;
        }
        for (EventProvider eventProvider : eventProviders) {
            eventProvider.setMethodName(methodName);
        }
        LinkedList counter = new LinkedList();
        UnaryOperator unaryOperator = eventProviderList -> eventProviderList.stream().filter(eventProvider -> {
            boolean result;
            boolean matchApplication = eventProvider.getServiceName().equals(nebulaEventDto.getAppName());
            boolean haveMatch = !CollectionUtils.isEmpty((Collection)counter) && counter.contains(nebulaEventDto.getAppName());
            boolean bl = result = matchApplication && !haveMatch;
            if (result) {
                counter.add(nebulaEventDto.getAppName());
            }
            return result;
        }).collect(Collectors.toList());
        Class<DirectNebulaNetEventConsumer> consumerClass = DirectNebulaNetEventConsumer.class;
        List nebulaNetEventConsumers = this.nebulaNetEventArrangement.arrangeEvent(eventProviders, unaryOperator, consumerClass);
        this.publish(nebulaEventDto, nebulaNetEventConsumers, NebulaNetEventConsumerChainImpl.class);
        ArrayList<String> responseList = new ArrayList<String>();
        for (NebulaNetEventConsumer consumer : nebulaNetEventConsumers) {
            if (!(consumer instanceof DirectNebulaNetEventConsumer)) continue;
            EventResponse eventResponse = ((DirectNebulaNetEventConsumer)consumer).getEventResponse();
            List eventResponses = eventResponse.getEventResponses();
            if (CollectionUtils.isEmpty((Collection)eventResponses)) {
                String jsonStr = JsonUtils.obj2JsonString((Object)eventResponse);
                responseList.add(jsonStr);
                continue;
            }
            responseList.addAll(eventResponses);
        }
        EventResponse eventResponse = new EventResponse();
        eventResponse.setEventResponses(responseList);
        eventResponse.setSubClassName(EventResponse.class.getName());
        return eventResponse;
    }

    private String getMethodName(SerializableBiConsumer<? extends NebulaEvent, ? extends NebulaEventDto> func) {
        String methodName;
        try {
            methodName = LambdaUtils.getFunctionName(func);
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bf7\u5728\u4ee3\u7801\u5185\u90e8\u6821\u9a8c\u6b63\u786e\u7684lambda\u8868\u8fbe\u5f0f", e);
        }
        return methodName;
    }
}

