/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.event.local.service.internal;

import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.event.local.service.assist.EventConsumerAssist;
import com.bizunited.nebula.event.sdk.dto.EventDto;
import com.bizunited.nebula.event.sdk.model.EventProvider;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventConsumerChain;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
@Scope(value="prototype")
@Lazy
public class NebulaNetEventConsumerImpl
implements NebulaNetEventConsumer {
    private static final Logger log = LoggerFactory.getLogger(NebulaNetEventConsumerImpl.class);
    private final EventProvider eventProvider;
    @Qualifier(value="nebulaEventRestTemplate")
    @Autowired
    private RestTemplate restTemplate;

    public NebulaNetEventConsumerImpl(EventProvider eventProvider) {
        this.eventProvider = eventProvider;
    }

    public void execute(NebulaEventDto nebulaEventDto, NebulaNetEventConsumerChain nebulaNetEventConsumerChain) {
        String uri = this.getUrl();
        EventDto eventDto = this.assignEventDto(nebulaEventDto);
        HttpHeaders header = EventConsumerAssist.getHttpHeaders();
        log.info(StringUtils.join((Object[])new Object[]{"nebula:event:\u5e7f\u64ad:\u8bf7\u6c42\u5730\u5740\uff1a", uri, "\u53c2\u6570\uff1a", eventDto}));
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.resolve((String)this.eventProvider.getRequestMethod()), new HttpEntity((Object)eventDto, (MultiValueMap)header), String.class, new Object[0]);
        boolean xxSuccessful = responseEntity.getStatusCode().is2xxSuccessful();
        if (!xxSuccessful) {
            throw new RuntimeException("" + responseEntity.getStatusCode().getReasonPhrase());
        }
        String body = (String)responseEntity.getBody();
        log.info(StringUtils.join((Object[])new String[]{"nebula:event:\u5e7f\u64ad:\u8fd4\u56de\u4fe1\u606f\uff1a", body}));
        ResponseModel responseModel = (ResponseModel)JsonUtils.json2Obj((String)body, ResponseModel.class);
        if (!responseModel.getSuccess().booleanValue()) {
            throw new RuntimeException(StringUtils.join((Object[])new String[]{responseModel.getErrorMsg(), " ", responseModel.getMessage()}));
        }
        nebulaNetEventConsumerChain.execute(nebulaEventDto);
    }

    private EventDto assignEventDto(NebulaEventDto nebulaEventDto) {
        EventDto eventDto = new EventDto();
        eventDto.setName(this.eventProvider.getDataId());
        eventDto.setMethodName(this.eventProvider.getMethodName());
        eventDto.setDtoClass(nebulaEventDto.getClass());
        eventDto.setJsonData(JsonUtils.obj2JsonString((Object)nebulaEventDto));
        return eventDto;
    }

    private String getUrl() {
        String tailUrl = StringUtils.join((Object[])new String[]{this.eventProvider.getServiceName(), "/", this.eventProvider.getContextPath(), "/", this.eventProvider.getClassUrl(), "/", this.eventProvider.getMethodUrl()});
        tailUrl = tailUrl.replaceAll("//", "/");
        return StringUtils.join((Object[])new String[]{this.eventProvider.getProtocol(), "://", tailUrl});
    }
}

