/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.event.local.service.internal;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.event.local.config.NacosConfig;
import com.bizunited.nebula.event.sdk.model.EventProvider;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventContainerManagement;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NebulaNetEventContainerManagementImpl
implements NebulaNetEventContainerManagement {
    private static final Logger log = LoggerFactory.getLogger(NebulaNetEventContainerManagementImpl.class);
    static final TypeReference<List<EventProvider>> type = new TypeReference<List<EventProvider>>(){};
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private ConfigService configService;
    @Autowired
    private NacosServiceManager nacosServiceManager;
    @Autowired
    private NacosDiscoveryProperties nacosDiscoveryProperties;
    @Value(value="${nacos._serviceName:}")
    private String serviceName;
    @Value(value="${nacos._protocol:http}")
    private String protocol;
    @Value(value="${nacos.timeoutMs:5000}")
    private long timeoutMs = 5000L;
    @Value(value="${nacos.close-delay:0}")
    private long closeDelay;
    @Autowired
    private NacosConfig nacosConfig;
    @Autowired
    private ApplicationContext applicationContext;

    public List<EventProvider> getEventProvider(Class<? extends NebulaEvent> event, String methodName) {
        try {
            String dataId = event.getName();
            String config = this.configService.getConfig(dataId, methodName, this.timeoutMs);
            List eventProviders = (List)JsonUtils.json2Obj((String)config, type);
            return eventProviders;
        }
        catch (NacosException e) {
            throw new RuntimeException(e.getErrMsg());
        }
    }

    private void pushNacos(String dataId, String group, List<EventProvider> eventProviders) {
        try {
            log.info("dataId:{}, group:{},configService:{}", new Object[]{dataId, group, this.configService});
            String config = this.configService.getConfig(dataId, group, this.timeoutMs);
            List eventProvidersInNacos = (List)JsonUtils.json2Obj((String)config, type);
            if (CollectionUtils.isEmpty((Collection)eventProvidersInNacos)) {
                eventProvidersInNacos = Lists.newLinkedList();
            }
            Collection union = org.apache.commons.collections.CollectionUtils.union(eventProviders, (Collection)eventProvidersInNacos);
            HashSet eventProviderSet = Sets.newHashSet((Iterable)union);
            this.configService.publishConfig(dataId, group, JsonUtils.obj2JsonString((Object)eventProviderSet), ConfigType.JSON.getType());
        }
        catch (NacosException e) {
            log.error("\u4e8b\u4ef6\u5f15\u64ce\u914d\u7f6e\u53d1\u5e03\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventProviderIgnore(Map<String, Set<NebulaEvent>> eventContainer) {
        if (CollectionUtils.isEmpty(eventContainer)) {
            return;
        }
        Environment environment = this.applicationContext.getEnvironment();
        String port = environment.getProperty("server.port");
        String contextPath = environment.getProperty("server.servlet.context-path");
        try {
            this.redisMutexService.lock("event:init:lock");
            if (this.checkOtherSamePortServerNodes().booleanValue()) {
                return;
            }
            for (Map.Entry<String, Set<NebulaEvent>> entry : eventContainer.entrySet()) {
                String dataId = entry.getKey();
                String group = "default";
                LinkedList eventProviders = Lists.newLinkedList();
                EventProvider eventProvider = this.assignEventProvider(port, contextPath, dataId, group);
                eventProviders.add(eventProvider);
                this.removeOneselfFromNacos(dataId, group, eventProviders);
            }
        }
        finally {
            this.shutDownCurrentServerNode();
            this.redisMutexService.unlock("event:init:lock");
        }
    }

    private void shutDownCurrentServerNode() {
        try {
            NamingService namingService = this.nacosServiceManager.getNamingService(this.nacosDiscoveryProperties.getNacosProperties());
            namingService.shutDown();
            if (this.closeDelay > 0L) {
                log.info("\u5ef6\u8fdf{}ms\u67e5\u8be2\u672c\u5b9e\u4f8b\u5728\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u8282\u70b9\u72b6\u6001........", (Object)this.closeDelay);
                Thread.sleep(this.closeDelay);
            }
            for (int i = 0; i < 30; ++i) {
                log.info("\u7b49\u5f85\u5173\u95ed\u672c\u5b9e\u4f8b\u5728\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u8282\u70b9........");
                if (this.checkExistsCurrentServerNode().booleanValue()) {
                    Thread.sleep(10000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("\u5173\u95ed\u672c\u5b9e\u4f8b\u5728\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u8282\u70b9\u5f02\u5e38", (Throwable)e);
        }
    }

    private EventProvider assignEventProvider(String port, String contextPath, String dataId, String group) {
        EventProvider eventProvider = new EventProvider();
        eventProvider.setPort(port);
        eventProvider.setContextPath(contextPath);
        eventProvider.setProtocol(this.protocol);
        eventProvider.setClassUrl("/v1/event/server");
        eventProvider.setDataId(dataId);
        eventProvider.setServiceName(this.serviceName);
        eventProvider.setMethodUrl("");
        eventProvider.setGroup(group);
        eventProvider.setRequestMethod(HttpMethod.POST.name());
        return eventProvider;
    }

    private void removeOneselfFromNacos(String dataId, String group, List<EventProvider> eventProviders) {
        try {
            String config = this.configService.getConfig(dataId, group, this.timeoutMs);
            List eventProvidersInNacos = (List)JsonUtils.json2Obj((String)config, type);
            if (CollectionUtils.isEmpty((Collection)eventProvidersInNacos)) {
                return;
            }
            Collection subtract = org.apache.commons.collections.CollectionUtils.subtract((Collection)eventProvidersInNacos, eventProviders);
            if (CollectionUtils.isEmpty((Collection)subtract)) {
                this.configService.removeConfig(dataId, group);
            } else {
                this.configService.publishConfig(dataId, group, JsonUtils.obj2JsonString((Object)subtract), ConfigType.JSON.getType());
            }
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    private Boolean checkExistsCurrentServerNode() throws NacosException {
        String host = this.nacosDiscoveryProperties.getIp();
        int port = this.nacosDiscoveryProperties.getPort();
        NamingService namingService = this.nacosServiceManager.getNamingService(this.nacosDiscoveryProperties.getNacosProperties());
        List instances = namingService.getAllInstances(this.serviceName, this.nacosDiscoveryProperties.getGroup(), false);
        instances = (List)ObjectUtils.defaultIfNull((Object)instances, (Object)Lists.newArrayList());
        return !CollectionUtils.isEmpty(instances = instances.stream().filter(instance -> Objects.equals(port, instance.getPort()) && Objects.equals(instance.getIp(), host)).collect(Collectors.toList()));
    }

    private Boolean checkOtherSamePortServerNodes() {
        Boolean result = Boolean.FALSE;
        try {
            String host = this.nacosDiscoveryProperties.getIp();
            int port = this.nacosDiscoveryProperties.getPort();
            NamingService namingService = this.nacosServiceManager.getNamingService(this.nacosDiscoveryProperties.getNacosProperties());
            List instances = namingService.getAllInstances(this.serviceName, this.nacosDiscoveryProperties.getGroup(), false);
            instances = (List)ObjectUtils.defaultIfNull((Object)instances, (Object)Lists.newArrayList());
            instances = instances.stream().filter(instance -> !Objects.equals(port, instance.getPort()) || !Objects.equals(instance.getIp(), host)).collect(Collectors.toList());
            String localHostPort = String.format("%s:%s", host, port);
            Set otherSamePortServerNodes = instances.stream().filter(instance -> Objects.equals(instance.getPort(), port)).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(otherSamePortServerNodes)) {
                log.info("\u4e8b\u4ef6\u5f15\u64ce\u670d\u52a1:{},\u4e0d\u5b58\u5728\u9664\u672c\u8282\u70b9host:{}\u4ee5\u5916\u7684\u7aef\u53e3\u4e00\u6837\u7684\u670d\u52a1\u8282\u70b9", (Object)this.serviceName, (Object)localHostPort);
            } else {
                Set hostPorts = otherSamePortServerNodes.stream().map(instance -> String.format("%s:%s", instance.getIp(), instance.getPort())).collect(Collectors.toSet());
                log.info("\u4e8b\u4ef6\u5f15\u64ce\u670d\u52a1:{},\u5b58\u5728\u9664\u672c\u8282\u70b9host:{}\u4ee5\u5916\u7684\u7aef\u53e3\u4e00\u6837\u7684\u670d\u52a1\u8282\u70b9hosts:{}", new Object[]{this.serviceName, localHostPort, hostPorts});
            }
            result = !CollectionUtils.isEmpty(otherSamePortServerNodes);
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u4e8b\u4ef6\u5f15\u64ce\u670d\u52a1\u662f\u5426\u8fd8\u6709\u5176\u4ed6\u7684\u7aef\u53e3\u4e0d\u4e00\u6837\u7684\u670d\u52a1\u8282\u70b9\u5b58\u5728\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putEventProvider(Map<String, Set<NebulaEvent>> eventContainer) {
        if (CollectionUtils.isEmpty(eventContainer)) {
            return;
        }
        Environment environment = this.applicationContext.getEnvironment();
        String port = environment.getProperty("server.port");
        String contextPath = environment.getProperty("server.servlet.context-path");
        try {
            this.redisMutexService.lock("event:init:lock");
            for (Map.Entry<String, Set<NebulaEvent>> entry : eventContainer.entrySet()) {
                String dataId = entry.getKey();
                String group = "default";
                LinkedList eventProviders = Lists.newLinkedList();
                EventProvider eventProvider = this.assignEventProvider(port, contextPath, dataId, group);
                eventProviders.add(eventProvider);
                this.pushNacos(dataId, group, eventProviders);
            }
        }
        finally {
            this.redisMutexService.unlock("event:init:lock");
        }
    }

    public List<EventProvider> getEventProvider(Class<? extends NebulaEvent> event) {
        try {
            String dataId = event.getName();
            String config = this.configService.getConfig(dataId, "default", this.timeoutMs);
            List eventProviders = (List)JsonUtils.json2Obj((String)config, type);
            return eventProviders;
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }
}

