/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.event.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.event.sdk.dto.EventDto;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEventServer;
import io.swagger.annotations.ApiParam;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
@RequestMapping(value={"/v1/event/server"})
public class EventController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(EventController.class);
    @Autowired
    private NebulaEventServer nebulaEventServer;

    @PostMapping(value={""})
    public ResponseModel create(@ApiParam(value="(\u25cf'\u25e1'\u25cf)") @RequestBody EventDto abstractEventDto) {
        try {
            this.printHeader();
            String name = abstractEventDto.getName();
            String methodName = abstractEventDto.getMethodName();
            Class dtoClass = abstractEventDto.getDtoClass();
            String jsonData = abstractEventDto.getJsonData();
            NebulaEventDto nebulaEventDto = (NebulaEventDto)JsonUtils.json2Obj((String)jsonData, (Class)dtoClass);
            EventResponse eventResponse = this.nebulaEventServer.execute(name, methodName, nebulaEventDto);
            return this.buildHttpResult(eventResponse);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return this.buildHttpResultForException(e);
        }
    }

    private void printHeader() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, String> map = new HashMap<String, String>();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                String values = request.getHeader(name);
                map.put(name, values);
            }
        }
        log.info("\u4e8b\u4ef6\u63a5\u6536\u7684header\uff0cnebula:event:header:{}", (Object)((Object)map).toString());
    }
}

