/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.event.local.service.assist;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.event.sdk.service.NebulaNonWebHttpHeaderStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class EventConsumerAssist {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerAssist.class);
    @Autowired(required=false)
    private List<NebulaNonWebHttpHeaderStrategy> strategyList;
    private static List<NebulaNonWebHttpHeaderStrategy> staticStrategyList;

    @PostConstruct
    public void init() {
        staticStrategyList = this.strategyList;
    }

    public static void transmit(HttpHeaders header) {
        if (SecurityContextHolder.getContext() == null || SecurityContextHolder.getContext().getAuthentication() == null) {
            return;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return;
        }
        Object details = authentication.getDetails();
        if (details == null) {
            return;
        }
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)details);
        String tenantCode = jsonObject.getString("tenantCode");
        String account = jsonObject.getString("account");
        Collection grantedAuthority = authentication.getAuthorities();
        if (CollectionUtils.isEmpty((Collection)grantedAuthority)) {
            return;
        }
        String[] roles = (String[])grantedAuthority.stream().map(GrantedAuthority::getAuthority).toArray(String[]::new);
        JSONObject authorizationVo = new JSONObject();
        authorizationVo.put("tenantCode", (Object)tenantCode);
        authorizationVo.put("account", (Object)account);
        authorizationVo.put("roles", Arrays.asList(roles));
        header.add("NON_WEB_REQUEST", authorizationVo.toJSONString());
    }

    public static HttpHeaders getHttpHeaders() {
        HttpHeaders header;
        block6: {
            header = new HttpHeaders();
            RequestAttributes requestAttributes = null;
            try {
                requestAttributes = RequestContextHolder.currentRequestAttributes();
                ServletRequestAttributes attributes = (ServletRequestAttributes)requestAttributes;
                HttpServletRequest request = attributes.getRequest();
                Enumeration headerNames = request.getHeaderNames();
                if (headerNames == null) break block6;
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    String values = request.getHeader(name);
                    if (name.equals("content-length")) continue;
                    if (name.equals("content-type")) {
                        header.add(name, "application/json");
                        continue;
                    }
                    header.add(name, values);
                }
            }
            catch (IllegalStateException e) {
                if (CollectionUtils.isEmpty(staticStrategyList)) {
                    return header;
                }
                for (NebulaNonWebHttpHeaderStrategy strategy : staticStrategyList) {
                    strategy.fill(header);
                }
            }
        }
        log.info("\u4e8b\u4ef6\u63d0\u4ea4\u524d\u7684header\uff0cnebula:event:header:{}", (Object)header.toString());
        return header;
    }
}

