/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.event.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.event.local.service.assist.EventConsumerAssist;
import com.bizunited.nebula.event.sdk.dto.EventDto;
import com.bizunited.nebula.event.sdk.model.EventProvider;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventConsumerChain;
import com.bizunited.nebula.event.sdk.service.NebulaResponseEventConsumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
@Scope(value="prototype")
@Lazy
public class DirectNebulaNetEventConsumer
implements NebulaResponseEventConsumer {
    private static final Logger log = LoggerFactory.getLogger(DirectNebulaNetEventConsumer.class);
    private final EventProvider eventProvider;
    private EventResponse eventResponse;
    @Qualifier(value="nebulaEventRestTemplate")
    @Autowired
    private RestTemplate restTemplate;

    public DirectNebulaNetEventConsumer(EventProvider eventProvider) {
        this.eventProvider = eventProvider;
    }

    public void execute(NebulaEventDto nebulaEventDto, NebulaNetEventConsumerChain nebulaNetEventConsumerChain) {
        String uri = this.getUrl();
        EventDto eventDto = this.assignEventDto(nebulaEventDto);
        HttpHeaders header = EventConsumerAssist.getHttpHeaders();
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.resolve((String)this.eventProvider.getRequestMethod()), new HttpEntity((Object)eventDto, (MultiValueMap)header), String.class, new Object[0]);
        boolean xxSuccessful = responseEntity.getStatusCode().is2xxSuccessful();
        if (!xxSuccessful) {
            throw new RuntimeException("" + responseEntity.getStatusCode().getReasonPhrase());
        }
        String body = (String)responseEntity.getBody();
        log.info(StringUtils.join((Object[])new String[]{"nebula:event:direct:\u8fd4\u56de\u4fe1\u606f\uff1a", body}));
        ResponseModel responseModel = (ResponseModel)JsonUtils.json2Obj((String)body, ResponseModel.class);
        Boolean success = responseModel.getSuccess();
        if (!success.booleanValue()) {
            throw new RuntimeException(responseModel.getErrorMsg());
        }
        Object data = responseModel.getData();
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)data);
        if (jsonObject == null) {
            throw new RuntimeException(StringUtils.join((Object[])new String[]{"\u4e8b\u4ef6\u76d1\u542c\u7aef\u53ef\u80fd\u62a5\u9519\u4e86\uff01", "nebula:event:direct:\u8fd4\u56de\u4fe1\u606f\uff1a", body, " >>\u4e8b\u4ef6\uff1a", eventDto.getName(), eventDto.getMethodName()}));
        }
        String subClassName = jsonObject.getString("subClassName");
        try {
            Class<?> subClass = Class.forName(subClassName);
            Object convert = JsonUtils.convert((Object)data, subClass);
            if (!(convert instanceof EventResponse)) {
                throw new RuntimeException("\u4e8b\u4ef6\u5f15\u64ce\u8fd4\u56de\u503c\u4e0d\u662fEventResponse\u7684\u5b50\u7c7b");
            }
            this.eventResponse = (EventResponse)convert;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("\u4e8b\u4ef6\u5f15\u64ceEventResponse\u7684\u5b50\u7c7b\u89e3\u6790\u5f02\u5e38", e);
        }
    }

    private EventDto assignEventDto(NebulaEventDto nebulaEventDto) {
        EventDto eventDto = new EventDto();
        eventDto.setName(this.eventProvider.getDataId());
        eventDto.setMethodName(this.eventProvider.getMethodName());
        eventDto.setDtoClass(nebulaEventDto.getClass());
        eventDto.setJsonData(JsonUtils.obj2JsonString((Object)nebulaEventDto));
        return eventDto;
    }

    private String getUrl() {
        String tailUrl = StringUtils.join((Object[])new String[]{this.eventProvider.getServiceName(), "/", this.eventProvider.getContextPath(), "/", this.eventProvider.getClassUrl(), "/", this.eventProvider.getMethodUrl()});
        tailUrl = tailUrl.replaceAll("//", "/");
        return StringUtils.join((Object[])new String[]{this.eventProvider.getProtocol(), "://", tailUrl});
    }

    public EventResponse getEventResponse() {
        return this.eventResponse;
    }
}

