/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.event.local.service.internal;

import com.bizunited.nebula.event.sdk.service.NebulaEvent;
import com.bizunited.nebula.event.sdk.service.NebulaEventContainerManagement;
import com.bizunited.nebula.event.sdk.util.AopTargetUtils;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NebulaEventContainerManagementImpl
implements NebulaEventContainerManagement {
    private Map<String, Set<NebulaEvent>> nebulaEventContainer = new ConcurrentHashMap<String, Set<NebulaEvent>>();
    @Autowired(required=false)
    List<NebulaEvent> nebulaEvents;

    public Set<NebulaEvent> getEventImplByClassName(String className) {
        return this.nebulaEventContainer.get(className);
    }

    public void putEventImplByClassName() {
        if (CollectionUtils.isEmpty(this.nebulaEvents)) {
            return;
        }
        for (NebulaEvent nebulaEvent : this.nebulaEvents) {
            Object target = null;
            try {
                target = AopTargetUtils.getTarget((Object)nebulaEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            Class<?> eventClass = target.getClass();
            Object[] interfaces = eventClass.getInterfaces();
            if (ArrayUtils.isEmpty((Object[])interfaces)) continue;
            for (Object anInterface : interfaces) {
                String name = ((Class)anInterface).getName();
                Set<NebulaEvent> eventSet = this.nebulaEventContainer.get(name);
                if (!CollectionUtils.isEmpty(eventSet)) {
                    eventSet.add(nebulaEvent);
                    continue;
                }
                HashSet set = Sets.newHashSet();
                set.add(nebulaEvent);
                this.nebulaEventContainer.put(name, set);
            }
        }
    }

    public Map<String, Set<NebulaEvent>> getEventContainer() {
        return this.nebulaEventContainer;
    }
}

