/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.event.local.service.internal;

import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;
import com.bizunited.nebula.event.sdk.service.NebulaEventContainerManagement;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEventServer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NebulaEventServerImpl
implements NebulaEventServer {
    @Autowired
    private NebulaEventContainerManagement nebulaEventContainerManagement;

    public EventResponse execute(String name, String methodName, NebulaEventDto nebulaEventDto) {
        EventResponse eventResponse = new EventResponse();
        ArrayList<String> responseList = new ArrayList<String>();
        Set eventList = this.nebulaEventContainerManagement.getEventImplByClassName(name);
        if (CollectionUtils.isEmpty((Collection)eventList)) {
            return eventResponse;
        }
        for (NebulaEvent nebulaEvent : eventList) {
            boolean equals;
            Object[] methods;
            boolean equals2;
            Class<?> eventClass = nebulaEvent.getClass();
            String eventClassName = eventClass.getName();
            String subClassName = nebulaEventDto.getSubClassName();
            if (StringUtils.isNotBlank((CharSequence)subClassName) && !(equals2 = eventClassName.equals(subClassName)) || ArrayUtils.isEmpty((Object[])(methods = eventClass.getMethods()))) continue;
            for (Object method : methods) {
                if (!((Method)method).getName().equals(methodName)) continue;
                try {
                    Object invoke = ((Method)method).invoke((Object)nebulaEvent, nebulaEventDto);
                    if (!EventResponse.class.isAssignableFrom(((Method)method).getReturnType())) break;
                    Class<?> returnType = ((Method)method).getReturnType();
                    if (!Objects.nonNull(invoke)) break;
                    EventResponse response = (EventResponse)invoke;
                    response.setSubClassName(returnType.getName());
                    String jsonStr = JsonUtils.obj2JsonString((Object)response);
                    responseList.add(jsonStr);
                    eventResponse = response;
                    break;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getTargetException().getMessage(), e);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)subClassName) || !(equals = eventClassName.equals(subClassName))) continue;
            break;
        }
        if (responseList.size() <= 1) {
            return eventResponse;
        }
        eventResponse = new EventResponse();
        eventResponse.setEventResponses(responseList);
        eventResponse.setSubClassName(EventResponse.class.getName());
        return eventResponse;
    }
}

