/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.event.local.service.internal;

import com.bizunited.nebula.event.local.service.internal.LocalNebulaNetEventConsumer;
import com.bizunited.nebula.event.local.service.internal.NebulaNetEventConsumerImpl;
import com.bizunited.nebula.event.sdk.model.EventProvider;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventArrangement;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventConsumer;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NebulaNetEventArrangementImpl
implements NebulaNetEventArrangement {
    @Value(value="${nacos._serviceName:}")
    private String serviceName;
    @Autowired
    private ApplicationContext applicationContext;

    public List<NebulaNetEventConsumer> arrangeEvent(List<EventProvider> eventProviders) {
        return this.arrangeEvent(eventProviders, NebulaNetEventConsumerImpl.class);
    }

    public List<NebulaNetEventConsumer> arrangeEvent(List<EventProvider> eventProviders, Class<? extends NebulaNetEventConsumer> clazz) {
        if (CollectionUtils.isEmpty(eventProviders)) {
            return Lists.newLinkedList();
        }
        HashSet counter = new HashSet(eventProviders.size());
        UnaryOperator unaryOperator = eventProviderList -> {
            List collect = eventProviderList.stream().filter(eventProvider -> {
                boolean contains = counter.contains(eventProvider.getContextPath());
                if (!contains) {
                    counter.add(eventProvider.getContextPath());
                }
                return !contains;
            }).sorted(Comparator.comparing(eventProvider -> Optional.ofNullable(eventProvider.getOrder()).map(Integer::valueOf).orElse(Integer.MAX_VALUE))).collect(Collectors.toList());
            return collect;
        };
        return this.arrangeEvent(eventProviders, unaryOperator, clazz);
    }

    public List<NebulaNetEventConsumer> arrangeEvent(List<EventProvider> eventProviders, UnaryOperator<List<EventProvider>> unaryOperator) {
        return this.arrangeEvent(eventProviders, unaryOperator, NebulaNetEventConsumerImpl.class);
    }

    public List<NebulaNetEventConsumer> arrangeEvent(List<EventProvider> eventProviders, UnaryOperator<List<EventProvider>> unaryOperator, Class<? extends NebulaNetEventConsumer> clazz) {
        eventProviders = (List)unaryOperator.apply(eventProviders);
        LinkedList nebulaNetEventConsumers = Lists.newLinkedList();
        Environment environment = this.applicationContext.getEnvironment();
        String port = environment.getProperty("server.port");
        String contextPath = environment.getProperty("server.servlet.context-path");
        for (EventProvider eventProvider : eventProviders) {
            boolean isSameJvm = port.equals(eventProvider.getPort()) && contextPath.equals(eventProvider.getContextPath()) && this.serviceName.equals(eventProvider.getServiceName());
            NebulaNetEventConsumer consumer = isSameJvm ? (NebulaNetEventConsumer)this.applicationContext.getBean(LocalNebulaNetEventConsumer.class, new Object[]{eventProvider}) : (NebulaNetEventConsumer)this.applicationContext.getBean(clazz, new Object[]{eventProvider});
            nebulaNetEventConsumers.add(consumer);
        }
        return nebulaNetEventConsumers;
    }
}

