/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.event.local.service.internal;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventConsumerChain;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Scope(value="prototype")
@Lazy
public class NebulaNetEventConsumerChainImpl
implements NebulaNetEventConsumerChain {
    private final List<NebulaNetEventConsumer> consumers;
    @Nullable
    private Iterator<NebulaNetEventConsumer> iterator;

    public NebulaNetEventConsumerChainImpl(List<NebulaNetEventConsumer> consumers) {
        this.consumers = CollectionUtils.isEmpty(consumers) ? Lists.newLinkedList() : consumers;
    }

    public void execute(NebulaEventDto nebulaEventDto) {
        if (this.iterator == null) {
            this.iterator = this.consumers.iterator();
        }
        if (this.iterator.hasNext()) {
            NebulaNetEventConsumer nextConsumer = this.iterator.next();
            nextConsumer.execute(nebulaEventDto, (NebulaNetEventConsumerChain)this);
        }
    }
}

