/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.event.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventConsumerChain;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Scope(value="prototype")
@Lazy
public class NebulaNetEventConsumerChainWithNoBreakImpl
implements NebulaNetEventConsumerChain {
    private static final Logger log = LoggerFactory.getLogger(NebulaNetEventConsumerChainWithNoBreakImpl.class);
    private final List<NebulaNetEventConsumer> consumers;
    @Nullable
    private Iterator<NebulaNetEventConsumer> iterator;

    public NebulaNetEventConsumerChainWithNoBreakImpl(List<NebulaNetEventConsumer> consumers) {
        this.consumers = CollectionUtils.isEmpty(consumers) ? Lists.newLinkedList() : consumers;
    }

    public void execute(NebulaEventDto nebulaEventDto) {
        if (this.iterator == null) {
            this.iterator = this.consumers.iterator();
        }
        if (this.iterator.hasNext()) {
            NebulaNetEventConsumer nextConsumer = this.iterator.next();
            try {
                nextConsumer.execute(nebulaEventDto, (NebulaNetEventConsumerChain)this);
            }
            catch (Exception e) {
                log.info("\u4e8b\u4ef6\u8c03\u7528\u53d1\u751f\u9519\u8bef, \u540e\u7eed\u4e8b\u4ef6\u5b9e\u73b0\u5c06\u7ee7\u7eed\u88ab\u8c03\u7528,\u6b64\u6b21\u8c03\u7528\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)nebulaEventDto));
                log.error("\u4e8b\u4ef6\u8c03\u7528\u5f02\u5e38", (Throwable)e);
                this.execute(nebulaEventDto);
            }
        }
    }
}

