/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.filter;

import com.alibaba.fastjson.JSON;
import com.bizunited.nebula.gateway.local.config.GatewayProperties;
import com.bizunited.nebula.gateway.local.filter.AbstractFilter;
import com.bizunited.nebula.gateway.local.filter.HeadResponseDecorator;
import com.bizunited.nebula.gateway.sdk.service.TenantInfoVoService;
import com.bizunited.nebula.gateway.sdk.vo.GatewayDomainVo;
import com.bizunited.nebula.gateway.sdk.vo.TenantInfoVo;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class HeadFilter
extends AbstractFilter
implements GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(HeadFilter.class);
    @Autowired
    private GatewayProperties gatewayProperties;
    @Value(value="${gateway.closeResponseLogs:false}")
    private Boolean closeResponseLogs;
    @Autowired
    private TenantInfoVoService tenantInfoVoService;

    public int getOrder() {
        return -4;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        URI sourceUrl = serverHttpRequest.getURI();
        String hostName = sourceUrl.getHost();
        log.debug("request sourceUrl = " + sourceUrl);
        if (StringUtils.isNotBlank((CharSequence)super.matchWhitelist(hostName))) {
            return chain.filter(exchange);
        }
        GatewayDomainVo gatewayDomain = this.existInLoadBalancerDomain(hostName);
        if (gatewayDomain == null) {
            return chain.filter(exchange);
        }
        String tenantCode = gatewayDomain.getTenantCode();
        TenantInfoVo tenantInfoVo = this.tenantInfoVoService.findByTenantCode(tenantCode);
        String tenantInfoJsonValue = JSON.toJSONString((Object)tenantInfoVo);
        String tenantInfoJsonBase64Value = Base64Utils.encodeToString((byte[])tenantInfoJsonValue.getBytes(StandardCharsets.UTF_8));
        String sourceBase64Value = Base64Utils.encodeToString((byte[])hostName.getBytes(StandardCharsets.UTF_8));
        HttpHeaders httpHeaders = serverHttpRequest.getHeaders();
        List overrides = httpHeaders.get((Object)"X-HTTP-Method-Override");
        HttpMethod overrideMethod = null;
        if (!CollectionUtils.isEmpty((Collection)overrides)) {
            String overrideMethodValue = (String)overrides.get(0);
            overrideMethod = HttpMethod.resolve((String)overrideMethodValue);
        }
        if (overrideMethod != null) {
            serverHttpRequest.mutate().method(overrideMethod).headers(item -> item.set("tenant", tenantInfoJsonBase64Value)).headers(item -> item.set("domain_source", sourceBase64Value)).method(overrideMethod).build();
        } else {
            serverHttpRequest.mutate().headers(item -> item.set("tenant", tenantInfoJsonBase64Value)).headers(item -> item.set("domain_source", sourceBase64Value)).build();
        }
        if (!this.closeResponseLogs.booleanValue()) {
            return chain.filter(exchange.mutate().response((ServerHttpResponse)new HeadResponseDecorator(exchange.getResponse(), this.gatewayProperties)).build());
        }
        return chain.filter(exchange);
    }
}

