/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.filter;

import com.bizunited.nebula.gateway.local.entity.InterfaceMonitorMapping;
import com.bizunited.nebula.gateway.local.entity.TenantDomain;
import com.bizunited.nebula.gateway.local.filter.AbstractFilter;
import com.bizunited.nebula.gateway.local.repository.TenantDomainRepository;
import com.bizunited.nebula.gateway.local.service.InterfaceMonitorMappingCacheService;
import java.net.URI;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class InterfaceAgentMonitorFilter
extends AbstractFilter
implements GlobalFilter,
Ordered {
    private static final String GATEWAY_REQUEST_URL_ATTR = "org.springframework.cloud.gateway.support.ServerWebExchangeUtils.gatewayRequestUrl";
    @Autowired
    private InterfaceMonitorMappingCacheService interfaceMonitorMappingCacheService;
    @Autowired
    private TenantDomainRepository tenantDomainRepository;

    public int getOrder() {
        return 10300;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        String hostName = serverHttpRequest.getURI().getHost();
        URI sourceUri = serverHttpRequest.getURI();
        InterfaceMonitorMapping interfaceMonitorMapping = this.interfaceMonitorMappingCacheService.findBySourceDomain(hostName);
        if (interfaceMonitorMapping == null || interfaceMonitorMapping.getInvokeType() != 2) {
            return chain.filter(exchange);
        }
        String targetAgreement = interfaceMonitorMapping.getTargetAgreement();
        String targetDomain = interfaceMonitorMapping.getTargetDomain();
        Integer targetPort = interfaceMonitorMapping.getTargetPort();
        TenantDomain tenantDomain = this.tenantDomainRepository.findByDomain(targetDomain);
        if (tenantDomain == null) {
            DataBuffer buffer = this.write500(exchange, "agent target uri error");
            return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
        }
        URI targetUri = this.toTargetUri(sourceUri, targetAgreement, targetPort, targetDomain);
        exchange.getAttributes().put(GATEWAY_REQUEST_URL_ATTR, targetUri);
        return chain.filter(exchange);
    }

    private DataBuffer write500(ServerWebExchange exchange, String errorMsg) {
        ServerHttpResponse serverHttpResponse = exchange.getResponse();
        serverHttpResponse.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
        DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(errorMsg.getBytes());
        return buffer;
    }
}

