/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.filter;

import com.bizunited.nebula.gateway.sdk.event.HttpProxyListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class MonitorControlResponseDecorator
extends ServerHttpResponseDecorator {
    private ServerHttpResponse originalResponse;
    private List<HttpProxyListener> httpProxyListeners;
    private ServerWebExchange exchange;
    private AtomicBoolean isTriggerEvent = new AtomicBoolean(false);

    public MonitorControlResponseDecorator(ServerHttpResponse originalResponse, List<HttpProxyListener> httpProxyListeners, ServerWebExchange exchange) {
        super(originalResponse);
        this.originalResponse = originalResponse;
        this.httpProxyListeners = httpProxyListeners;
        this.exchange = exchange;
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        DataBufferFactory dataBufferFactory = this.originalResponse.bufferFactory();
        if (body instanceof Flux) {
            Flux flux = (Flux)body;
            return super.writeWith((Publisher)flux.map(dataBuffer -> {
                byte[] destinations = new byte[dataBuffer.readableByteCount()];
                dataBuffer.read(destinations);
                DataBufferUtils.release((DataBuffer)dataBuffer);
                if (!this.isTriggerEvent.getAndSet(true) && !CollectionUtils.isEmpty(this.httpProxyListeners)) {
                    for (HttpProxyListener httpProxyListener : this.httpProxyListeners) {
                        httpProxyListener.onProxyResponse(this.exchange, destinations);
                    }
                }
                return dataBufferFactory.wrap(destinations);
            }));
        }
        return super.writeWith(body);
    }
}

