/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.filter;

import com.bizunited.nebula.gateway.sdk.event.HttpProxyListener;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RequestBodyGlobalFilter
implements GlobalFilter,
Ordered {
    @Autowired(required=false)
    private List<HttpProxyListener> httpProxyListeners;

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        ServerHttpResponse originalResponse = exchange.getResponse();
        DataBufferFactory dataBufferFactory = originalResponse.bufferFactory();
        Flux body = serverHttpRequest.getBody();
        DataBuffer defaultDataBuffer = dataBufferFactory.allocateBuffer(0);
        return DataBufferUtils.join((Publisher)body.defaultIfEmpty((Object)defaultDataBuffer)).flatMap(dataBuffer -> {
            byte[] destinations = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(destinations);
            DataBufferUtils.release((DataBuffer)dataBuffer);
            exchange.getAttributes().put("REQUEST_BODY", destinations);
            if (!CollectionUtils.isEmpty(this.httpProxyListeners)) {
                for (HttpProxyListener httpProxyListener : this.httpProxyListeners) {
                    httpProxyListener.onProxyRequest(exchange, destinations);
                }
            }
            return chain.filter(exchange);
        });
    }
}

