/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.filter;

import com.bizunited.nebula.gateway.local.filter.AbstractFilter;
import com.bizunited.nebula.gateway.sdk.service.TenantInfoVoService;
import com.bizunited.nebula.gateway.sdk.vo.GatewayDomainVo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class TenantStatusFilter
extends AbstractFilter
implements GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(TenantStatusFilter.class);
    @Autowired
    private TenantInfoVoService tenantInfoVoService;

    public int getOrder() {
        return -2;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        String hostName = serverHttpRequest.getURI().getHost();
        if (StringUtils.isNotBlank((CharSequence)super.matchWhitelist(hostName))) {
            return chain.filter(exchange);
        }
        GatewayDomainVo gatewayDomain = this.existInLoadBalancerDomain(hostName);
        if (gatewayDomain == null) {
            return chain.filter(exchange);
        }
        String tenantCode = gatewayDomain.getTenantCode();
        if (!this.tenantInfoVoService.validateStatus(tenantCode).booleanValue()) {
            log.debug("tenant code " + tenantCode + " is disable!!");
        }
        return chain.filter(exchange);
    }
}

