/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.repository;

import com.bizunited.nebula.gateway.local.entity.TenantInfo;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="_TenantInfoRepository")
public interface TenantInfoRepository
extends JpaRepository<TenantInfo, String>,
JpaSpecificationExecutor<TenantInfo> {
    @Query(value="from TenantInfo b order by b.createTime ")
    public List<TenantInfo> findAll();

    @Query(value="select distinct tenantServer from TenantInfo tenantServer left join fetch tenantServer.tenantDomains td  left join fetch tenantServer.bucketInfo bi  left join fetch bi.gatewayInfo gi  where gi.gatewayCode = :gatewayCode")
    public Set<TenantInfo> findDetailsByGatewayCode(@Param(value="gatewayCode") String var1);

    @Query(value="select distinct tenantServer from TenantInfo tenantServer left join fetch tenantServer.bucketInfo bi  where bi.gatewayInfo.gatewayCode = :gatewayCode and tenantServer.state = 1")
    public Set<TenantInfo> findByGatewayCode(@Param(value="gatewayCode") String var1);

    @Query(value="from TenantInfo tenantInfo  left join fetch tenantInfo.bucketInfo bi  left join fetch bi.gatewayInfo gi  where gi.gatewayCode = :gatewayCode AND tenantInfo.tenantCode =:tenantCode ")
    public TenantInfo findByGatewayCodeAndTenantCode(@Param(value="gatewayCode") String var1, @Param(value="tenantCode") String var2);

    @Query(value="select distinct tenantServer from TenantInfo tenantServer  left join fetch tenantServer.previousBucketInfo tenantServer_previousBucketInfo  left join fetch tenantServer.bucketInfo tenantServer_bucketInfo  left join fetch tenantServer.tenantDomains domains  where tenantServer.id=:id ")
    public TenantInfo findDetailsById(@Param(value="id") String var1);

    @Query(value="select distinct tenantServer from TenantInfo tenantServer  left join fetch tenantServer.previousBucketInfo tenantServer_previousBucketInfo  left join fetch tenantServer.bucketInfo tenantServer_bucketInfo  left join fetch tenantServer.tenantDomains domains  where tenantServer.tenantCode=:tenantCode ")
    public TenantInfo findDetailsByTenantCode(@Param(value="tenantCode") String var1);

    public long countByTenantCode(String var1);

    public long countByWebKey(String var1);

    public List<TenantInfo> findByState(Integer var1);
}

