/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.config;

import com.bizunited.nebula.gateway.local.config.GatewayProperties;
import com.bizunited.nebula.gateway.local.log.LogInfo;
import com.bizunited.nebula.gateway.local.log.LogPersistenceTask;
import com.bizunited.nebula.gateway.local.service.internal.GatewayDomainVoServiceImpl;
import com.bizunited.nebula.gateway.local.service.internal.TenantInfoFlowServiceImpl;
import com.bizunited.nebula.gateway.local.service.internal.TenantInfoVoServiceImpl;
import com.bizunited.nebula.gateway.sdk.service.GatewayDomainVoService;
import com.bizunited.nebula.gateway.sdk.service.TenantInfoFlowService;
import com.bizunited.nebula.gateway.sdk.service.TenantInfoVoService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.http.HttpStatus;
import reactor.core.publisher.Mono;

@Configuration
@ComponentScan(value={"com.bizunited.nebula.gateway.local"})
@EnableConfigurationProperties(value={GatewayProperties.class})
@EntityScan(value={"com.bizunited.nebula.gateway.local.entity"})
@EnableJpaRepositories(basePackages={"com.bizunited.nebula.gateway.local.repository"})
@EnableElasticsearchRepositories(basePackages={"com.bizunited.nebula.gateway.local.log"})
public class GatewayConfiguration {
    @Value(value="${server.http.port:8081}")
    private int httpPort;
    @Value(value="${server.port:80}")
    private int serverPort;
    @Value(value="${server.ssl.enabled:false}")
    private boolean sslEnable;

    @PostConstruct
    public void startRedirectServer() {
        if (this.sslEnable) {
            NettyReactiveWebServerFactory httpNettyReactiveWebServerFactory = new NettyReactiveWebServerFactory(this.httpPort);
            httpNettyReactiveWebServerFactory.getWebServer((request, response) -> {
                URI httpsUri;
                URI uri = request.getURI();
                try {
                    httpsUri = new URI("https", uri.getUserInfo(), uri.getHost(), this.serverPort, uri.getPath(), uri.getQuery(), uri.getFragment());
                }
                catch (URISyntaxException e) {
                    return Mono.error((Throwable)e);
                }
                response.setStatusCode(HttpStatus.PERMANENT_REDIRECT);
                response.getHeaders().setLocation(httpsUri);
                return response.setComplete();
            }).start();
        }
    }

    @Bean
    public RouteLocator customRouteLocator(RouteLocatorBuilder routeLocatorBuilder) {
        RouteLocatorBuilder.Builder routes = routeLocatorBuilder.routes();
        return routes.route(r -> r.path(new String[]{"/**"}).uri("http://127.0.0.1:8081/")).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={GatewayDomainVoService.class})
    public GatewayDomainVoService buildGatewayDomainVoService() {
        return new GatewayDomainVoServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={TenantInfoVoService.class})
    public TenantInfoVoService buildTenantInfoVoService() {
        return new TenantInfoVoServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={TenantInfoFlowService.class})
    public TenantInfoFlowService buildTenantInfoFlowService() {
        return new TenantInfoFlowServiceImpl();
    }

    @Bean(value={"gateway_log_PersistenceThreadExecutor"})
    public ThreadPoolExecutor getPersistenceThreadExecutor(final ApplicationContext applicationContext) {
        ThreadPoolExecutor persistenceThreadExecutor = new ThreadPoolExecutor(10, 20, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100000), new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "gateway_log_persistenceThread_" + this.count.incrementAndGet());
                ClassLoader classLoader = applicationContext.getClassLoader();
                thread.setContextClassLoader(classLoader);
                thread.setDaemon(false);
                return thread;
            }
        });
        return persistenceThreadExecutor;
    }

    @Bean
    @Scope(value="prototype")
    @Lazy
    public LogPersistenceTask getLogPersistenceTask(LogInfo logInfo) {
        LogPersistenceTask logPersistenceTask = new LogPersistenceTask(logInfo);
        return logPersistenceTask;
    }
}

