/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.filter;

import com.bizunited.nebula.gateway.sdk.service.GatewayDomainVoService;
import com.bizunited.nebula.gateway.sdk.vo.GatewayDomainVo;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractFilter {
    @Value(value="${gateway.whitelist.sourceHost:}")
    private String[] whitelistSourceHosts;
    @Value(value="${gateway.whitelist.targetHost:}")
    private String[] whitelistTargetHosts;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFilter.class);
    @Autowired
    private GatewayDomainVoService gatewayDomainVoService;

    protected String matchWhitelist(String hostName) {
        if (this.whitelistSourceHosts != null && this.whitelistSourceHosts.length > 0 && this.whitelistTargetHosts != null && this.whitelistTargetHosts.length > 0 && this.whitelistSourceHosts.length == this.whitelistTargetHosts.length) {
            for (int index = 0; index < this.whitelistSourceHosts.length; ++index) {
                if (!StringUtils.equals((CharSequence)this.whitelistSourceHosts[index], (CharSequence)hostName)) continue;
                return this.whitelistTargetHosts[index];
            }
        }
        return null;
    }

    protected GatewayDomainVo existInLoadBalancerDomain(String hostName) {
        GatewayDomainVo gatewayDomain = this.gatewayDomainVoService.findByExternalDomain(hostName);
        if (gatewayDomain == null) {
            gatewayDomain = this.gatewayDomainVoService.findByInternalDomain(hostName);
        }
        return gatewayDomain;
    }

    protected String analysisQueryParams(String sourceQuery) throws UnsupportedEncodingException {
        String targetQuery = URLDecoder.decode(sourceQuery, Charsets.UTF_8.name());
        String[] targetQueryParams = StringUtils.split((String)targetQuery, (String)"\\&");
        ArrayList targetEncodeQueryParams = Lists.newArrayList();
        for (String targetQueryParam : targetQueryParams) {
            String[] paramValuesMapping = StringUtils.split((String)targetQueryParam, (String)"=", (int)2);
            if (paramValuesMapping == null || paramValuesMapping.length != 2) continue;
            String key = paramValuesMapping[0];
            String value = paramValuesMapping[1];
            value = StringUtils.isNotBlank((CharSequence)value) ? URLEncoder.encode(value, Charsets.UTF_8.name()) : "";
            targetEncodeQueryParams.add(StringUtils.join((Object[])new String[]{key, "=", value}));
        }
        targetQuery = StringUtils.join((Object[])targetEncodeQueryParams.toArray(new String[0]), (String)"&");
        return targetQuery;
    }

    protected URI toTargetUri(URI sourceUri, String scheme, Integer targetPort, String targetHost) {
        try {
            String sourceQuery = sourceUri.getQuery();
            String targetQuery = null;
            if (StringUtils.isNotBlank((CharSequence)sourceQuery)) {
                targetQuery = this.analysisQueryParams(sourceQuery);
            }
            URI targetUri = new URI(scheme, sourceUri.getUserInfo(), targetHost, targetPort, sourceUri.getPath(), null, sourceUri.getFragment());
            if (StringUtils.isNotBlank((CharSequence)sourceQuery)) {
                return new URI(StringUtils.join((Object[])new String[]{targetUri.toString(), "?", targetQuery}));
            }
            return new URI(targetUri.toString());
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

