/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.filter;

import com.bizunited.nebula.gateway.local.entity.InterfaceMonitorMapping;
import com.bizunited.nebula.gateway.local.filter.AbstractFilter;
import com.bizunited.nebula.gateway.local.service.InterfaceMonitorMappingCacheService;
import com.bizunited.nebula.gateway.sdk.vo.GatewayDomainVo;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class NotFoundFilter
extends AbstractFilter
implements GlobalFilter,
Ordered {
    @Autowired
    private InterfaceMonitorMappingCacheService interfaceMonitorMappingCacheService;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        InterfaceMonitorMapping interfaceMonitorMapping;
        GatewayDomainVo gatewayDomain;
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        URI sourceUrl = serverHttpRequest.getURI();
        String hostName = sourceUrl.getHost();
        boolean if404 = true;
        if (StringUtils.isNotBlank((CharSequence)super.matchWhitelist(hostName))) {
            if404 = false;
        }
        if ((gatewayDomain = this.existInLoadBalancerDomain(hostName)) != null) {
            if404 = false;
        }
        if ((interfaceMonitorMapping = this.interfaceMonitorMappingCacheService.findBySourceDomain(hostName)) != null) {
            if404 = false;
        }
        if (if404) {
            DataBuffer buffer = this.write404(exchange);
            return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
        }
        return chain.filter(exchange);
    }

    private DataBuffer write404(ServerWebExchange exchange) {
        ServerHttpResponse serverHttpResponse = exchange.getResponse();
        serverHttpResponse.setStatusCode(HttpStatus.NOT_FOUND);
        DataBuffer buffer = exchange.getResponse().bufferFactory().wrap("".getBytes());
        return buffer;
    }
}

