/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.filter;

import com.bizunited.nebula.gateway.local.filter.AbstractFilter;
import com.bizunited.nebula.gateway.sdk.service.GatewayDomainVoService;
import com.bizunited.nebula.gateway.sdk.vo.GatewayDomainVo;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class RefererFilter
extends AbstractFilter
implements GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(RefererFilter.class);
    @Autowired
    private GatewayDomainVoService gatewayDomainVoService;
    @Value(value="${gateway.whitelist.referer:}")
    private String[] refererWhitelist;
    @Value(value="${gateway.whitelist.ignoreRefererValidate:false}")
    private boolean ignoreRefererValidate;

    public int getOrder() {
        return -5;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        URI refUri;
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        URI sourceUrl = serverHttpRequest.getURI();
        log.debug("sourceUrl = " + sourceUrl);
        String hostName = sourceUrl.getHost();
        if (StringUtils.isNotBlank((CharSequence)super.matchWhitelist(hostName)) || this.ignoreRefererValidate) {
            return chain.filter(exchange);
        }
        GatewayDomainVo gatewayDomain = this.existInLoadBalancerDomain(hostName);
        if (gatewayDomain == null) {
            return chain.filter(exchange);
        }
        HttpMethod httpMethod = serverHttpRequest.getMethod();
        if (httpMethod == HttpMethod.GET) {
            return chain.filter(exchange);
        }
        log.debug("hostName = " + hostName);
        gatewayDomain = this.gatewayDomainVoService.findByInternalDomain(hostName);
        if (gatewayDomain == null) {
            DataBuffer buffer = this.write403(exchange);
            return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
        }
        log.debug("\u6b63\u5728\u8fdb\u884creferer\u4fe1\u606f\u76d1\u6d4b=====");
        HttpHeaders httpHeaders = serverHttpRequest.getHeaders();
        List referers = httpHeaders.get((Object)"Referer");
        log.debug("referers is empty = " + CollectionUtils.isEmpty((Collection)referers));
        if (CollectionUtils.isEmpty((Collection)referers)) {
            DataBuffer buffer = this.write403(exchange);
            return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
        }
        String referer = (String)referers.get(0);
        if (StringUtils.isBlank((CharSequence)referer)) {
            DataBuffer buffer = this.write403(exchange);
            return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
        }
        if (this.refererWhitelist != null && this.refererWhitelist.length > 0) {
            for (String refererWhiteItem : this.refererWhitelist) {
                log.debug("referer = " + referer + " \uff0c refererWhiteItem = " + refererWhiteItem);
                if (StringUtils.indexOf((CharSequence)referer, (CharSequence)refererWhiteItem) != 0) continue;
                return chain.filter(exchange);
            }
        }
        if ((refUri = URI.create(referer)) == null) {
            DataBuffer buffer = this.write403(exchange);
            return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
        }
        String refHostName = refUri.getHost();
        if (this.gatewayDomainVoService.findByExternalDomain(refHostName) != null || this.gatewayDomainVoService.findByInternalDomain(refHostName) != null) {
            return chain.filter(exchange);
        }
        DataBuffer buffer = this.write403(exchange);
        return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
    }

    private DataBuffer write403(ServerWebExchange exchange) {
        ServerHttpResponse serverHttpResponse = exchange.getResponse();
        serverHttpResponse.setStatusCode(HttpStatus.FORBIDDEN);
        DataBuffer buffer = exchange.getResponse().bufferFactory().wrap("".getBytes());
        return buffer;
    }
}

