/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.init;

import com.bizunited.nebula.gateway.local.config.GatewayProperties;
import com.bizunited.nebula.gateway.local.strategy.GroovyRouteGroupStrategyFileListenerAdaptor;
import java.io.File;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component(value="routeGroupStrategyInit")
public class RouteGroupStrategyInit
implements ApplicationRunner {
    @Autowired
    private GatewayProperties gatewayProperties;
    @Autowired
    private GroovyRouteGroupStrategyFileListenerAdaptor groovyRouteGroupStrategyFileListenerAdaptor;

    public void run(ApplicationArguments args) throws Exception {
        String groovyFilePath = this.gatewayProperties.getGroovyFilePath();
        if (StringUtils.isBlank((CharSequence)groovyFilePath)) {
            return;
        }
        File directory = new File(groovyFilePath);
        Validate.isTrue((boolean)directory.exists(), (String)"\u6307\u5b9a\u7684\u8def\u7531\u7b56\u7565\u811a\u672c\uff08groovy\uff09\u6587\u4ef6\u7684\u7ba1\u7406\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        FileAlterationObserver fileAlterationObserver = new FileAlterationObserver(directory);
        fileAlterationObserver.addListener((FileAlterationListener)this.groovyRouteGroupStrategyFileListenerAdaptor);
        FileAlterationMonitor fileMonitor = new FileAlterationMonitor(300000L, new FileAlterationObserver[]{fileAlterationObserver});
        fileMonitor.start();
    }
}

