/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.log;

import com.bizunited.nebula.gateway.local.entity.InterfaceMonitorMapping;
import com.bizunited.nebula.gateway.local.log.LogInfo;
import com.bizunited.nebula.gateway.local.log.LogPersistenceTask;
import com.bizunited.nebula.gateway.local.service.InterfaceMonitorMappingCacheService;
import com.bizunited.nebula.gateway.sdk.event.HttpProxyListener;
import com.google.common.collect.Lists;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

@Component
public class LogInfoHttpInvokeListener
implements HttpProxyListener {
    @Autowired
    private InterfaceMonitorMappingCacheService interfaceMonitorMappingCacheService;
    private static final String ATTRIBUTE_NAME = "HTTP_INVOKE_LOG";
    @Autowired
    @Qualifier(value="gateway_log_PersistenceThreadExecutor")
    private ThreadPoolExecutor persistenceThreadExecutor;
    @Autowired
    private ApplicationContext applicationContext;

    public void onProxyRequest(ServerWebExchange exchange, byte[] requestBodyContent) {
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        URI uri = serverHttpRequest.getURI();
        String hostName = uri.getHost();
        InterfaceMonitorMapping interfaceMonitorMapping = this.interfaceMonitorMappingCacheService.findBySourceDomain(hostName);
        if (interfaceMonitorMapping == null || interfaceMonitorMapping.getInvokeType() != 1) {
            return;
        }
        String logId = exchange.getAttributes().get(ServerWebExchange.LOG_ID_ATTRIBUTE).toString();
        List<String> cookiesValues = this.buildCookies(serverHttpRequest);
        List<String> queryParamValues = this.buildQueryParams(serverHttpRequest);
        List<String> headerParamValues = this.buildHeaderParams(serverHttpRequest.getHeaders());
        LogInfo logInfo = new LogInfo();
        logInfo.setLogId(logId);
        logInfo.setTenantCode(interfaceMonitorMapping.getTenantCode());
        logInfo.setMonitorName(interfaceMonitorMapping.getMonitorName());
        logInfo.setSourceDomain(hostName);
        logInfo.setRequestTime(new Date());
        logInfo.setRequestCookies(StringUtils.join((Object[])new List[]{cookiesValues}));
        logInfo.setRequestParam(StringUtils.join((Object[])new List[]{queryParamValues}));
        logInfo.setRequestHeaders(StringUtils.join((Object[])new List[]{headerParamValues}));
        if (requestBodyContent != null && requestBodyContent.length > 0) {
            logInfo.setRequestBody(StringUtils.toEncodedString((byte[])requestBodyContent, (Charset)Charset.forName("utf-8")));
        } else {
            logInfo.setRequestBody("");
        }
        logInfo.setInvokeType(interfaceMonitorMapping.getInvokeType());
        logInfo.setTargetAgreement(interfaceMonitorMapping.getTargetAgreement());
        logInfo.setTargetDomain(interfaceMonitorMapping.getTargetDomain());
        logInfo.setTargetPort(interfaceMonitorMapping.getTargetPort());
        exchange.getAttributes().put(ATTRIBUTE_NAME, logInfo);
        LogPersistenceTask logPersistenceTask = (LogPersistenceTask)this.applicationContext.getBean(LogPersistenceTask.class, new Object[]{logInfo});
        this.persistenceThreadExecutor.submit(logPersistenceTask);
    }

    private List<String> buildHeaderParams(HttpHeaders httpHeaders) {
        ArrayList headerParamValues = Lists.newArrayList();
        for (Map.Entry httpHeaderItem : httpHeaders.entrySet()) {
            String headerName = (String)httpHeaderItem.getKey();
            List headerValues = (List)httpHeaderItem.getValue();
            if (CollectionUtils.isEmpty((Collection)headerValues)) continue;
            for (String headerValue : headerValues) {
                headerParamValues.add(StringUtils.join((Object[])new String[]{headerName, "=", headerValue, ";", System.lineSeparator()}));
            }
        }
        return headerParamValues;
    }

    private List<String> buildQueryParams(ServerHttpRequest serverHttpRequest) {
        ArrayList queryParamValues = Lists.newArrayList();
        MultiValueMap queryParamMapping = serverHttpRequest.getQueryParams();
        if (!CollectionUtils.isEmpty((Map)queryParamMapping)) {
            for (Map.Entry queryParamItem : queryParamMapping.entrySet()) {
                String paramName = (String)queryParamItem.getKey();
                List paramValues = (List)queryParamItem.getValue();
                if (CollectionUtils.isEmpty((Collection)paramValues)) continue;
                for (String paramValue : paramValues) {
                    queryParamValues.add(StringUtils.join((Object[])new String[]{paramName, "=", paramValue, ";", paramValue}));
                }
            }
        }
        return queryParamValues;
    }

    private List<String> buildCookies(ServerHttpRequest serverHttpRequest) {
        ArrayList cookiesValues = Lists.newArrayList();
        MultiValueMap httpCookieMap = serverHttpRequest.getCookies();
        if (!CollectionUtils.isEmpty((Map)httpCookieMap)) {
            for (Map.Entry httpCookieItem : httpCookieMap.entrySet()) {
                List cookies = (List)httpCookieItem.getValue();
                if (CollectionUtils.isEmpty((Collection)cookies)) continue;
                for (HttpCookie httpCookie : cookies) {
                    cookiesValues.add(StringUtils.join((Object[])new String[]{httpCookie.getName(), "=", httpCookie.getValue(), ";", System.lineSeparator()}));
                }
            }
        }
        return cookiesValues;
    }

    public void onProxyResponse(ServerWebExchange exchange, byte[] responseBodyContent) {
        Object logInfoObject = exchange.getAttributes().get(ATTRIBUTE_NAME);
        if (logInfoObject == null) {
            return;
        }
        LogInfo logInfo = (LogInfo)logInfoObject;
        String hostName = logInfo.getSourceDomain();
        InterfaceMonitorMapping interfaceMonitorMapping = this.interfaceMonitorMappingCacheService.findBySourceDomain(hostName);
        if (interfaceMonitorMapping == null || interfaceMonitorMapping.getInvokeType() != 1) {
            return;
        }
        ServerHttpResponse response = exchange.getResponse();
        List<String> cookiesValues = this.buildCookies(response);
        List<String> headerParamValues = this.buildHeaderParams(response.getHeaders());
        Integer responseCode = response.getRawStatusCode();
        if (responseCode == null) {
            responseCode = response.getStatusCode().value();
        }
        logInfo.setResponseTime(new Date());
        logInfo.setResponseCode(responseCode);
        if (responseBodyContent != null && responseBodyContent.length > 0) {
            logInfo.setRequestBody(StringUtils.toEncodedString((byte[])responseBodyContent, (Charset)Charset.forName("utf-8")));
        } else {
            logInfo.setRequestBody("");
        }
        logInfo.setResponseCookies(StringUtils.join((Object[])new List[]{cookiesValues}));
        logInfo.setResponseHeaders(StringUtils.join((Object[])new List[]{headerParamValues}));
        LogPersistenceTask logPersistenceTask = (LogPersistenceTask)this.applicationContext.getBean(LogPersistenceTask.class, new Object[]{logInfo});
        this.persistenceThreadExecutor.submit(logPersistenceTask);
    }

    private List<String> buildCookies(ServerHttpResponse response) {
        ArrayList cookiesValues = Lists.newArrayList();
        MultiValueMap httpCookieMap = response.getCookies();
        if (!CollectionUtils.isEmpty((Map)httpCookieMap)) {
            for (Map.Entry responseCookieItem : httpCookieMap.entrySet()) {
                List cookies = (List)responseCookieItem.getValue();
                if (CollectionUtils.isEmpty((Collection)cookies)) continue;
                for (HttpCookie httpCookie : cookies) {
                    cookiesValues.add(StringUtils.join((Object[])new String[]{httpCookie.getName(), "=", httpCookie.getValue(), ";", System.lineSeparator()}));
                }
            }
        }
        return cookiesValues;
    }
}

