/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.service.internal;

import com.bizunited.nebula.gateway.local.entity.BucketInfo;
import com.bizunited.nebula.gateway.local.entity.GatewayInfo;
import com.bizunited.nebula.gateway.local.repository.BucketBootRepository;
import com.bizunited.nebula.gateway.local.repository.BucketInfoRepository;
import com.bizunited.nebula.gateway.local.repository.BucketNodejsRepository;
import com.bizunited.nebula.gateway.local.repository.GatewayInfoRepository;
import com.bizunited.nebula.gateway.local.service.BucketInfoService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BucketInfoServiceImpl
implements BucketInfoService {
    @Autowired
    private BucketInfoRepository bucketInfoRepository;
    @Autowired
    private GatewayInfoRepository gatewayInfoRepository;
    @Autowired
    private BucketBootRepository bucketBootRepository;
    @Autowired
    private BucketNodejsRepository bucketNodejsRepository;

    @Override
    @Transactional
    public BucketInfo create(BucketInfo bucketInfo) {
        Validate.notNull((Object)bucketInfo, (String)"\u8d44\u6e90\u6876\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        bucketInfo.setId(null);
        String bucketCode = bucketInfo.getBucketCode();
        Validate.notBlank((CharSequence)bucketCode, (String)"\u8d44\u6e90\u6876\u7f16\u53f7(bucketCode)\u5fc5\u987b\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        long existCount = this.bucketInfoRepository.countByBucketCode(bucketCode);
        Validate.isTrue((existCount == 0L ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u8d44\u6e90\u6876\u4e1a\u52a1\u7f16\u7801\uff08\u6709\u91cd\u590d\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validate(bucketInfo);
        Date now = new Date();
        bucketInfo.setCreateAccount("admin");
        bucketInfo.setCreateTime(now);
        bucketInfo.setExpire(false);
        bucketInfo.setModifyAccount("admin");
        bucketInfo.setModifyTime(now);
        this.bucketInfoRepository.save(bucketInfo);
        return bucketInfo;
    }

    private void validate(BucketInfo bucketInfo) {
        Boolean monopoly = bucketInfo.getMonopoly();
        Validate.notNull((Object)monopoly, (String)"\u5fc5\u987b\u8bbe\u5b9a\u8fd9\u4e2a\u8d44\u6e90\u6876\u662f\u5426\u4e3a\u5355\u79df\u6237\u72ec\u5360\u7684\u8d44\u6e90\u6876", (Object[])new Object[0]);
        Iterable bucketInfos = this.bucketInfoRepository.findAll();
        Boolean approve = bucketInfo.getApprove();
        Validate.notNull((Object)approve, (String)"\u5fc5\u987b\u8bbe\u5b9a\u8d44\u6e90\u6876\u662f\u5426\u662f\u9ed8\u8ba4\u8d44\u6e90\u6876\uff0c\u53ea\u6709\u4e00\u4e2a\u8d44\u6e90\u6876\u80fd\u591f\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u8d44\u6e90\u6876", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)bucketInfos) && approve.booleanValue()) {
            long approveCount = bucketInfos.stream().filter(item -> item.getApprove()).count();
            Validate.isTrue((approveCount == 0L ? 1 : 0) != 0, (String)"\u5728\u7cfb\u7edf\u4e2d\uff0c\u5df2\u7ecf\u53d1\u73b0\u4e86\u5de5\u4f5c\u4e2d\u7684\u9ed8\u8ba4\u8d44\u6e90\u6876\uff08\u65e0\u8bba\u5b83\u662f\u5426\u6709\u6548\uff09\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u7b2c\u4e8c\u4e2a\u9ed8\u8ba4\u8d44\u6e90\u6876\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((monopoly == false ? 1 : 0) != 0, (String)"\u5982\u679c\u5f53\u524d\u8d44\u6e90\u6876\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u8d44\u6e90\u6876\uff0c\u5219\u8be5\u8d44\u6e90\u6876\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u201c\u79df\u6237\u72ec\u5360\u201d\u6a21\u5f0f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        GatewayInfo gatewayInfo = bucketInfo.getGatewayInfo();
        Validate.notNull((Object)gatewayInfo, (String)"\u8d44\u6e90\u6876\u9009\u5b9a\u7684\u7f51\u5173\u4fe1\u606f\u5fc5\u987b\u643a\u5e26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String gatewayInfoId = gatewayInfo.getId();
        Validate.notBlank((CharSequence)gatewayInfoId, (String)"\u8d44\u6e90\u6876\u9009\u5b9a\u7684\u7f51\u5173\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u643a\u5e26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull(this.gatewayInfoRepository.findById(gatewayInfoId).orElse(null), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7f51\u5173\u4fe1\u606f\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        String remark = bucketInfo.getRemark();
        Validate.notBlank((CharSequence)remark, (String)"\u8d44\u6e90\u6876\u7684\u8bf4\u660e\u4fe1\u606f\uff0c\u5fc5\u987b\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String versionCode = bucketInfo.getVersionCode();
        Validate.notBlank((CharSequence)versionCode, (String)"\u8d44\u6e90\u6876\u7248\u672c\u7f16\u53f7\u5fc5\u987b\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String versionValue = bucketInfo.getVersionValue();
        Validate.notBlank((CharSequence)versionValue, (String)"\u8d44\u6e90\u6876\u7248\u672c\u503c\u5fc5\u987b\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public BucketInfo update(BucketInfo bucketInfo) {
        Validate.notNull((Object)bucketInfo, (String)"\u8d44\u6e90\u6876\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String id = bucketInfo.getId();
        Validate.notBlank((CharSequence)id, (String)"\u9519\u8bef\u7684\u6280\u672f\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        BucketInfo currentBucketInfo = this.bucketInfoRepository.findById(id).orElse(null);
        Validate.notNull((Object)currentBucketInfo, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u8d44\u6e90\u6876\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validate(bucketInfo);
        currentBucketInfo.setApprove(bucketInfo.getApprove());
        currentBucketInfo.setExpire(bucketInfo.getExpire());
        Date now = new Date();
        currentBucketInfo.setModifyAccount("admin");
        currentBucketInfo.setModifyTime(now);
        currentBucketInfo.setMonopoly(bucketInfo.getMonopoly());
        currentBucketInfo.setRemark(bucketInfo.getRemark());
        currentBucketInfo.setVersionCode(bucketInfo.getVersionCode());
        currentBucketInfo.setVersionValue(bucketInfo.getVersionValue());
        this.bucketInfoRepository.save(currentBucketInfo);
        return currentBucketInfo;
    }

    @Override
    @Transactional
    public void bind(String bucketInfoId, String gatewayInfoId) {
        Validate.notBlank((CharSequence)bucketInfoId, (String)"\u8bf7\u4f20\u5165\u6307\u5b9a\u7684\u8d44\u6e90\u6876\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        BucketInfo currentBucketInfo = this.bucketInfoRepository.findById(bucketInfoId).orElse(null);
        Validate.notNull((Object)currentBucketInfo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8d44\u6e90\u6876\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)gatewayInfoId, (String)"\u8bf7\u4f20\u5165\u6307\u5b9a\u7684\u7f51\u5173\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        GatewayInfo currentGatewayInfo = this.gatewayInfoRepository.findById(gatewayInfoId).orElse(null);
        Validate.notNull((Object)currentGatewayInfo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7f51\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentBucketInfo.setGatewayInfo(currentGatewayInfo);
        this.bucketInfoRepository.save(currentBucketInfo);
    }

    @Override
    @Transactional
    public void enable(String bucketInfoId) {
        Validate.notBlank((CharSequence)bucketInfoId, (String)"\u5fc5\u987b\u4f20\u5165\u6307\u5b9a\u7684\u8d44\u6e90\u6876\u6280\u672f\u7f16\u53f7", (Object[])new Object[0]);
        BucketInfo currentBucketInfo = this.bucketInfoRepository.findById(bucketInfoId).orElse(null);
        Validate.notNull((Object)currentBucketInfo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8d44\u6e90\u6876\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentBucketInfo.setExpire(false);
        this.bucketInfoRepository.save(currentBucketInfo);
    }

    @Override
    @Transactional
    public void disable(String bucketInfoId) {
        Validate.notBlank((CharSequence)bucketInfoId, (String)"\u5fc5\u987b\u4f20\u5165\u6307\u5b9a\u7684\u8d44\u6e90\u6876\u6280\u672f\u7f16\u53f7", (Object[])new Object[0]);
        BucketInfo currentBucketInfo = this.bucketInfoRepository.findById(bucketInfoId).orElse(null);
        Validate.notNull((Object)currentBucketInfo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8d44\u6e90\u6876\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentBucketInfo.setExpire(true);
        this.bucketInfoRepository.save(currentBucketInfo);
    }

    @Override
    public List<BucketInfo> findAll() {
        Iterable bucketInfos = this.bucketInfoRepository.findAll();
        return bucketInfos;
    }

    @Override
    public BucketInfo findDetailsById(String bucketInfoId) {
        if (StringUtils.isBlank((CharSequence)bucketInfoId)) {
            return null;
        }
        return this.bucketInfoRepository.findDetailsById(bucketInfoId);
    }

    @Override
    public List<BucketInfo> findByGatewayInfo(String gatewayInfoId) {
        if (StringUtils.isBlank((CharSequence)gatewayInfoId)) {
            return null;
        }
        return this.bucketInfoRepository.findDetailsByGatewayInfo(gatewayInfoId);
    }

    @Override
    public List<Integer> findAppTypeById(String bucketInfoId, boolean external) {
        if (StringUtils.isBlank((CharSequence)bucketInfoId)) {
            return null;
        }
        if (external) {
            return this.bucketNodejsRepository.findAppTypeById(bucketInfoId);
        }
        return this.bucketBootRepository.findAppTypeById(bucketInfoId);
    }
}

