/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.service.internal;

import com.bizunited.nebula.gateway.local.entity.BucketInfo;
import com.bizunited.nebula.gateway.local.entity.BucketNodejs;
import com.bizunited.nebula.gateway.local.repository.BucketInfoRepository;
import com.bizunited.nebula.gateway.local.repository.BucketNodejsRepository;
import com.bizunited.nebula.gateway.local.service.BucketNodejsService;
import com.bizunited.nebula.gateway.local.utils.IpUtils;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BucketNodejsServiceImpl
implements BucketNodejsService {
    @Autowired
    private BucketNodejsRepository bucketNodejsRepository;
    @Autowired
    private BucketInfoRepository bucketInfoRepository;

    @Override
    public BucketNodejs create(BucketNodejs bucketNodejs) {
        Validate.notNull((Object)bucketNodejs, (String)"\u9519\u8bef\u7684node\u8282\u70b9\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        bucketNodejs.setId(null);
        this.validate(bucketNodejs);
        this.bucketNodejsRepository.save(bucketNodejs);
        return bucketNodejs;
    }

    private void validate(BucketNodejs bucketNode) {
        String agreement = bucketNode.getAgreement();
        Validate.isTrue((boolean)StringUtils.equalsAny((CharSequence)agreement, (CharSequence[])new CharSequence[]{"http", "https"}), (String)"\u534f\u8bae\u4fe1\u606f\u53ea\u80fd\u662fhttp\u6216\u8005https", (Object[])new Object[0]);
        Integer appType = bucketNode.getAppType();
        Validate.notNull((Object)appType, (String)"\u5fc5\u987b\u9009\u62e9spring boot\u8282\u70b9\u7684\u5e94\u7528\u7a0b\u5e8f\u7c7b\u578b", (Object[])new Object[0]);
        String groupCode = bucketNode.getGroupCode();
        if (StringUtils.isBlank((CharSequence)groupCode)) {
            bucketNode.setGroupCode(null);
        }
        String ip = bucketNode.getIp();
        Validate.isTrue((boolean)IpUtils.validIPAddress(ip), (String)"\u8282\u70b9\u7684IP\u683c\u5f0f\u5e76\u4e0d\u7b26\u5408\u6b63\u786e\u7684\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Integer port = bucketNode.getPort();
        Validate.notNull((Object)port, (String)"\u9519\u8bef\u7684\u7aef\u53e3\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((port >= 1 && port <= 65535 ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u7aef\u53e3\u503c[\u6700\u592765534]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        BucketInfo bucketInfo = bucketNode.getBucketInfo();
        Validate.notNull((Object)bucketInfo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8d44\u6e90\u6876\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String bucketInfoId = bucketInfo.getId();
        Validate.notBlank((CharSequence)bucketInfoId, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8d44\u6e90\u6876\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        BucketInfo currentBucketInfo = this.bucketInfoRepository.findById(bucketInfoId).orElse(null);
        Validate.notNull((Object)currentBucketInfo, (String)"\u672a\u5728\u6570\u636e\u5e93\u4e2d\u627e\u5230\u6307\u5b9a\u7684\u8d44\u6e90\u6876\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
    }

    @Override
    public BucketNodejs update(BucketNodejs bucketNodejs) {
        Validate.notNull((Object)bucketNodejs, (String)"\u9519\u8bef\u7684node\u8282\u70b9\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String id = bucketNodejs.getId();
        BucketNodejs currentBucketNodejs = this.bucketNodejsRepository.findById(id).orElse(null);
        Validate.notNull((Object)currentBucketNodejs, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684node\u8282\u70b9\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validate(bucketNodejs);
        currentBucketNodejs.setAgreement(bucketNodejs.getAgreement());
        currentBucketNodejs.setAppType(bucketNodejs.getAppType());
        currentBucketNodejs.setGroupCode(bucketNodejs.getGroupCode());
        currentBucketNodejs.setIp(bucketNodejs.getIp());
        currentBucketNodejs.setPort(bucketNodejs.getPort());
        this.bucketNodejsRepository.save(currentBucketNodejs);
        return currentBucketNodejs;
    }

    @Override
    @Transactional
    public void bind(String bucketInfoId, Set<String> bucketNodeIds) {
        Validate.notBlank((CharSequence)bucketInfoId, (String)"\u9519\u8bef\u7684\u8d44\u6e90\u6876\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        BucketInfo currentBucketInfo = this.bucketInfoRepository.findById(bucketInfoId).orElse(null);
        Validate.notNull((Object)currentBucketInfo, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u8d44\u6e90\u6876\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (String bucketNodeId : bucketNodeIds) {
            BucketNodejs bucketNodejs = this.bucketNodejsRepository.findById(bucketNodeId).orElse(null);
            Validate.notNull((Object)bucketNodejs, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684node\u8282\u70b9\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            bucketNodejs.setBucketInfo(currentBucketInfo);
            this.bucketNodejsRepository.save(bucketNodejs);
        }
    }

    @Override
    @Transactional
    public void deleteByBucketNodeId(String bucketNodeId) {
        Validate.notBlank((CharSequence)bucketNodeId, (String)"\u5fc5\u987b\u6307\u5b9anode\u8282\u70b9\u7684\u7f16\u53f7", (Object[])new Object[0]);
        this.bucketNodejsRepository.deleteById(bucketNodeId);
    }

    @Override
    public List<BucketNodejs> findByBucketInfo(String bucketInfoId) {
        if (StringUtils.isBlank((CharSequence)bucketInfoId)) {
            return null;
        }
        List<BucketNodejs> results = this.bucketNodejsRepository.findDetailsByBucketInfo(bucketInfoId);
        return results;
    }
}

