/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.bizunited.nebula.gateway.local.config.GatewayProperties;
import com.bizunited.nebula.gateway.sdk.service.GroovyInvokeCachedService;
import com.bizunited.nebula.gateway.sdk.strategy.ScriptRouteStrategy;
import com.bizunited.nebula.gateway.sdk.vo.GatewayDomainVo;
import com.bizunited.nebula.gateway.sdk.vo.TenantDomainVo;
import com.bizunited.nebula.gateway.sdk.vo.TenantInfoVo;
import com.google.common.collect.Maps;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;

public class GroovyInvokeCachedServiceImpl
implements GroovyInvokeCachedService {
    private static final Logger log = LoggerFactory.getLogger(GroovyInvokeCachedServiceImpl.class);
    private final String TENANT = "tenant";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private GatewayProperties gatewayProperties;
    private static Map<String, Object> groovyObjectMapping = Maps.newConcurrentMap();
    private ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        String groovyFilePath = this.gatewayProperties.getGroovyFilePath();
        if (StringUtils.isBlank((CharSequence)groovyFilePath)) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try (GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.applicationContext.getClassLoader());){
            groovyObjectMapping.clear();
            File groovyFileDir = new File(groovyFilePath);
            Validate.isTrue((boolean)groovyFileDir.exists(), (String)"groovy\u811a\u672c\u6587\u4ef6\u7684\u52a0\u8f7d\u8def\u5f84\u6ca1\u6709\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            File[] childFiles = groovyFileDir.listFiles();
            if (childFiles == null) return;
            if (childFiles.length == 0) {
                return;
            }
            File[] groovyFiles = (File[])Arrays.stream(childFiles).filter(fileItem -> fileItem.isFile() && StringUtils.lastIndexOf((CharSequence)fileItem.getName(), (CharSequence)".groovy") != -1).toArray(File[]::new);
            if (groovyFiles == null) return;
            if (groovyFiles.length == 0) {
                return;
            }
            File[] fileArray = groovyFiles;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File groovyFile = fileArray[n2];
                Class groovyClass = groovyClassLoader.parseClass(groovyFile);
                if (ScriptRouteStrategy.class.isAssignableFrom(groovyClass)) {
                    String className = groovyClass.getName();
                    groovyObjectMapping.put(className, groovyClass.newInstance());
                }
                ++n2;
            }
            return;
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invoke(ServerWebExchange exchange, GatewayDomainVo gatewayDomain) {
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        HttpHeaders headers = serverHttpRequest.getHeaders();
        Thread currentThread = Thread.currentThread();
        String threadName = currentThread.getName();
        ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            HashMap params = Maps.newHashMap();
            params.put("request", serverHttpRequest);
            params.put("headers", headers);
            for (Map.Entry<String, Object> entryItem : groovyObjectMapping.entrySet()) {
                String fileName = entryItem.getKey();
                Object groovyObject = entryItem.getValue();
                String result = this.invokeOne(StringUtils.join((Object[])new String[]{threadName, "_", fileName}), (ScriptRouteStrategy)groovyObject, serverHttpRequest, headers);
                if (StringUtils.isBlank((CharSequence)result)) continue;
                String string = result;
                return string;
            }
        }
        finally {
            readLock.unlock();
        }
        return null;
    }

    private String invokeOne(String key, ScriptRouteStrategy scriptRouteStrategy, ServerHttpRequest request, HttpHeaders headers) {
        try {
            log.info("---\u5f00\u59cb\u6267\u884cGroovy\u811a\u672c");
            List tenantList = request.getHeaders().get((Object)"tenant");
            if (CollectionUtils.isEmpty((Collection)tenantList)) {
                log.info("---\u5934\u4fe1\u606f\u65e0tenant\u4fe1\u606f");
                return null;
            }
            String encodeTenant = (String)tenantList.get(0);
            byte[] encodedBytes = Base64Utils.decodeFromString((String)encodeTenant);
            String decodeHeaders = new String(encodedBytes, StandardCharsets.UTF_8);
            TenantInfoVo tenantInfoVo = (TenantInfoVo)JSON.parseObject((String)decodeHeaders, TenantInfoVo.class);
            Boolean isCallInterface = false;
            List tenantDomains = tenantInfoVo.getTenantDomains();
            if (CollectionUtils.isEmpty((Collection)tenantDomains)) {
                return null;
            }
            String host = request.getURI().getHost();
            String url = request.getURI().getPath();
            for (TenantDomainVo tenantDomainVo : tenantDomains) {
                if (!StringUtils.equals((CharSequence)host, (CharSequence)tenantDomainVo.getDomain()) || tenantDomainVo.getExternal().booleanValue()) continue;
                isCallInterface = true;
            }
            if (!isCallInterface.booleanValue()) {
                return null;
            }
            String[] parts = url.split("/");
            if (parts.length < 2) {
                return null;
            }
            log.info("contains groupCode=" + parts[1]);
            return parts[1];
        }
        catch (RuntimeException e) {
            log.error("\u811a\u672c\u6267\u884c\u5f02\u5e38 e\uff1a{}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
            return null;
        }
    }
}

