/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.service.internal;

import com.bizunited.nebula.gateway.local.entity.InterfaceMonitorMapping;
import com.bizunited.nebula.gateway.local.repository.InterfaceMonitorMappingRepository;
import com.bizunited.nebula.gateway.local.service.InterfaceMonitorMappingCacheService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InterfaceMonitorMappingCacheServiceImpl
implements InterfaceMonitorMappingCacheService {
    @Autowired
    private InterfaceMonitorMappingRepository interfaceMonitorMappingRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(InterfaceMonitorMappingCacheServiceImpl.class);
    private LoadingCache<String, InterfaceMonitorMapping> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterfaceMonitorMapping findBySourceDomain(String sourceDomain) {
        if (StringUtils.isBlank((CharSequence)sourceDomain)) {
            return null;
        }
        if (this.cache == null) {
            InterfaceMonitorMappingCacheServiceImpl interfaceMonitorMappingCacheServiceImpl = this;
            synchronized (interfaceMonitorMappingCacheServiceImpl) {
                while (this.cache == null) {
                    this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, InterfaceMonitorMapping>(){

                        public InterfaceMonitorMapping load(String sourceDomain) throws Exception {
                            InterfaceMonitorMapping current = InterfaceMonitorMappingCacheServiceImpl.this.interfaceMonitorMappingRepository.findBySourceDomain(sourceDomain);
                            if (current == null) {
                                current = new InterfaceMonitorMapping();
                            }
                            return current;
                        }
                    });
                }
            }
        }
        InterfaceMonitorMapping current = null;
        try {
            current = (InterfaceMonitorMapping)this.cache.get((Object)sourceDomain);
            if (current == null || StringUtils.isBlank((CharSequence)current.getId())) {
                return null;
            }
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return current;
    }
}

