/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.service.internal;

import com.bizunited.nebula.gateway.local.dto.InterfaceMonitorMappingDto;
import com.bizunited.nebula.gateway.local.entity.InterfaceMonitorMapping;
import com.bizunited.nebula.gateway.local.repository.InterfaceMonitorMappingRepository;
import com.bizunited.nebula.gateway.local.service.InterfaceMonitorMappingService;
import com.bizunited.nebula.gateway.sdk.service.TenantInfoVoService;
import com.bizunited.nebula.gateway.sdk.vo.TenantDomainVo;
import com.bizunited.nebula.gateway.sdk.vo.TenantInfoVo;
import java.util.Collection;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InterfaceMonitorMappingServiceImpl
implements InterfaceMonitorMappingService {
    @Autowired
    private InterfaceMonitorMappingRepository interfaceMonitorMappingRepository;
    @Autowired
    private TenantInfoVoService tenantInfoVoService;

    @Override
    @Transactional
    public InterfaceMonitorMapping create(InterfaceMonitorMapping entity) {
        String onTime = "\u521b\u5efa\u63a5\u53e3\u6620\u5c04\u5173\u7cfb\u65f6";
        Validate.notNull((Object)entity, (String)(onTime + "\uff0c\u5fc5\u987b\u4f20\u9012\u65b0\u7684\u6620\u5c04\u4fe1\u606f\u3002"), (Object[])new Object[0]);
        String sourceDomain = entity.getSourceDomain();
        Validate.notBlank((CharSequence)sourceDomain, (String)(onTime + "\uff0c\u8bf7\u6c42\u6e90\u5730\u5740\uff08\u57df\u540d/IP\uff09\u4fe1\u606f\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        InterfaceMonitorMapping existInterfaceMonitorMapping = this.interfaceMonitorMappingRepository.findBySourceDomain(sourceDomain);
        Validate.isTrue((existInterfaceMonitorMapping == null ? 1 : 0) != 0, (String)(onTime + "\uff0c\u4f7f\u7528\u7684\u6e90\u5730\u5740\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4"), (Object[])new Object[0]);
        this.validate(onTime, entity);
        return (InterfaceMonitorMapping)this.interfaceMonitorMappingRepository.save(entity);
    }

    private void validate(String onTime, InterfaceMonitorMapping entity) {
        String monitorName = entity.getMonitorName();
        Validate.notBlank((CharSequence)monitorName, (String)(onTime + "\uff0c\u6620\u5c04\u65e5\u5fd7\u610f\u4e49\u63cf\u8ff0\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        Integer invokeType = entity.getInvokeType();
        Validate.notNull((Object)invokeType, (String)(onTime + "\uff0c\u8c03\u7528\u7c7b\u578b\u5fc5\u987b\u586b\u5199"), (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)2L, (long)invokeType.intValue(), (String)(onTime + "\uff0c\u8c03\u7528\u7c7b\u578b\u53ea\u80fd\u4e3a1\u6216\u80052"));
        String tenantCode = entity.getTenantCode();
        Validate.notBlank((CharSequence)tenantCode, (String)(onTime + "\uff0c\u79df\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        Integer appType = entity.getAppType();
        Validate.notNull((Object)appType, (String)(onTime + "\uff0c\u7cfb\u7edf\u7c7b\u578b\u4fe1\u606f\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        String groupCode = entity.getGroupCode();
        Validate.notBlank((CharSequence)groupCode, (String)(onTime + "\uff0c\u5e94\u7528\u7cfb\u7edf\u5206\u7ec4\u4fe1\u606f\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        String targetAgreement = entity.getTargetAgreement();
        Validate.isTrue((boolean)StringUtils.equalsAny((CharSequence)targetAgreement, (CharSequence[])new CharSequence[]{"http", "https"}), (String)(onTime + "\uff0c\u8bf7\u6c42\u76ee\u6807\u534f\u8bae\u4fe1\u606f\uff08http/https\uff09\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        Integer targetPort = entity.getTargetPort();
        Validate.notNull((Object)targetPort, (String)(onTime + "\uff0c\u8bf7\u6c42\u76ee\u6807\u7aef\u53e3\u4fe1\u606f\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        String remark = entity.getRemark();
        Validate.notBlank((CharSequence)remark, (String)(onTime + "\uff0c\u8be5\u65e5\u5fd7\u76d1\u63a7\u6620\u5c04\u8bbe\u7f6e\u7684\u5907\u6ce8\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        String targetDomain = entity.getTargetDomain();
        Validate.notBlank((CharSequence)targetDomain, (String)(onTime + "\uff0c\u8bf7\u6c42\u76ee\u6807\u5730\u5740\uff08\u57df\u540d/IP\uff09\u4fe1\u606f\u5fc5\u987b\u4f20\u5165"), (Object[])new Object[0]);
        TenantInfoVo tenantInfoVo = this.tenantInfoVoService.findByTenantCode(tenantCode);
        Validate.notNull((Object)tenantInfoVo, (String)(onTime + "\uff0c\u79df\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        List tenantDomains = tenantInfoVo.getTenantDomains();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)tenantDomains) ? 1 : 0) != 0, (String)(onTime + "\uff0c\u672a\u627e\u5230\u6b63\u786e\u7684\u57df\u540d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5"), (Object[])new Object[0]);
        TenantDomainVo currentTenantDomainVo = tenantDomains.stream().filter(tenantDomain -> appType.intValue() == tenantDomain.getAppType().intValue()).findFirst().orElse(null);
        Validate.notNull((Object)currentTenantDomainVo, (String)(onTime + "\uff0c\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u79df\u6237\u6709\u6307\u5b9a\u7684\u7cfb\u7edf\u7c7b\u578bappType"), (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public InterfaceMonitorMapping update(InterfaceMonitorMapping entity) {
        String onTime = "\u4fee\u6539\u63a5\u53e3\u6620\u5c04\u5173\u7cfb\u65f6";
        Validate.notNull((Object)entity, (String)(onTime + "\uff0c\u5fc5\u987b\u4f20\u9012\u65b0\u7684\u6620\u5c04\u4fe1\u606f\u3002"), (Object[])new Object[0]);
        String id = entity.getId();
        Validate.notBlank((CharSequence)id, (String)(onTime + "\uff0c\u5fc5\u987b\u4f20\u9012\u4fee\u6539\u4fe1\u606f\u7684id\u7f16\u53f7\u3002"), (Object[])new Object[0]);
        InterfaceMonitorMapping current = this.interfaceMonitorMappingRepository.findById(id).orElse(null);
        Validate.notNull((Object)current, (String)(onTime + "\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        this.validate(onTime, entity);
        current.setAppType(entity.getAppType());
        current.setMonitorName(entity.getMonitorName());
        current.setGroupCode(entity.getGroupCode());
        current.setInvokeType(entity.getInvokeType());
        current.setRemark(entity.getRemark());
        current.setTargetAgreement(entity.getTargetAgreement());
        current.setTargetDomain(entity.getTargetDomain());
        current.setTargetPort(entity.getTargetPort());
        current.setTenantCode(entity.getTenantCode());
        return (InterfaceMonitorMapping)this.interfaceMonitorMappingRepository.save(current);
    }

    @Override
    @Transactional
    public void delete(String mappingId) {
        Validate.notBlank((CharSequence)mappingId, (String)"\u5220\u9664\u6620\u5c04\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8981\u5220\u9664\u7684\u6761\u76eeid", (Object[])new Object[0]);
        InterfaceMonitorMapping exsit = this.interfaceMonitorMappingRepository.findById(mappingId).orElse(null);
        Validate.notNull((Object)exsit, (String)"\u5220\u9664\u6620\u5c04\u4fe1\u606f\u65f6\uff0c\u6307\u5b9a\u5220\u9664\u7684\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.interfaceMonitorMappingRepository.delete(exsit);
    }

    @Override
    public InterfaceMonitorMapping findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        InterfaceMonitorMapping interfaceMonitorMapping = this.interfaceMonitorMappingRepository.findById(id).orElse(null);
        return interfaceMonitorMapping;
    }

    @Override
    public Page<InterfaceMonitorMapping> findByConditions(Pageable pageable, InterfaceMonitorMappingDto conditions) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)20);
        }
        return this.interfaceMonitorMappingRepository.findByConditions(pageable, conditions);
    }
}

