/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.service.internal;

import com.bizunited.nebula.gateway.local.entity.BucketBoot;
import com.bizunited.nebula.gateway.local.entity.BucketInfo;
import com.bizunited.nebula.gateway.local.entity.GatewayInfo;
import com.bizunited.nebula.gateway.local.entity.TenantInfo;
import com.bizunited.nebula.gateway.local.repository.BucketBootRepository;
import com.bizunited.nebula.gateway.local.repository.GatewayInfoRepository;
import com.bizunited.nebula.gateway.local.repository.TenantDomainRepository;
import com.bizunited.nebula.gateway.local.repository.TenantInfoRepository;
import com.bizunited.nebula.gateway.sdk.service.TenantInfoFlowService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class TenantInfoFlowServiceImpl
implements TenantInfoFlowService {
    private static final Logger log = LoggerFactory.getLogger(TenantInfoFlowServiceImpl.class);
    public static final Object LOCK_OBJECT = new Object();
    private static final int DEFAULT_PRENODE_MAX_CONCURRENT = 20000;
    @Value(value="${gateway.code}")
    private String gatewayCode;
    @Autowired
    private TenantInfoRepository tenantInfoRepository;
    @Autowired
    private TenantDomainRepository tenantDomainRepository;
    @Autowired
    private GatewayInfoRepository gatewayInfoRepository;
    @Autowired
    private BucketBootRepository bucketBootRepository;
    private static Map<String, Semaphore> tenantConcurrentMapping = Maps.newConcurrentMap();
    private static Map<String, Integer> totalWeightCountMapping;
    private static volatile boolean isRefreshing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void refresh() {
        GatewayInfo gatewayInfo = this.gatewayInfoRepository.findByGatewayCode(this.gatewayCode);
        if (gatewayInfo == null) {
            log.error("\u53d1\u73b0\u6570\u636e\u5e93\u4e2d\u5f53\u524d\u7f51\u5173\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u8fdb\u884c\u9650\u6d41\u63a7\u5236\u5237\u65b0\uff0c\u8bf7\u68c0\u67e5!!");
            return;
        }
        List<BucketInfo> bucketInfos = gatewayInfo.getBucketInfos();
        if (CollectionUtils.isEmpty(bucketInfos = bucketInfos.stream().filter(item -> item.getExpire() == false).collect(Collectors.toList()))) {
            log.error("\u53d1\u73b0\u6570\u636e\u5e93\u4e2d\u5f53\u524d\u7f51\u5173\uff0c\u6ca1\u6709\u8bbe\u5b9a\u4efb\u4f55\u6709\u6548\u7684\uff08expire = false\uff09\u8d44\u6e90\u6876\u4fe1\u606f\uff0c\u4e0d\u80fd\u8fdb\u884c\u9650\u6d41\u63a7\u5236\u5237\u65b0\uff0c\u8bf7\u68c0\u67e5!!");
            return;
        }
        HashMap bucketBootNodeMapping = Maps.newHashMap();
        for (BucketInfo bucketInfo : bucketInfos) {
            List<BucketBoot> bucketBoots = this.bucketBootRepository.findDetailsByBucketInfo(bucketInfo.getId());
            if (CollectionUtils.isEmpty(bucketBoots)) continue;
            String bucketCode = bucketInfo.getBucketCode();
            Map<Integer, List<BucketBoot>> apptypeGroups = bucketBoots.stream().collect(Collectors.groupingBy(BucketBoot::getAppType));
            if (CollectionUtils.isEmpty(apptypeGroups)) continue;
            for (Map.Entry<Integer, List<BucketBoot>> groupItem : apptypeGroups.entrySet()) {
                Integer appType = groupItem.getKey();
                List<BucketBoot> bucketBootList = groupItem.getValue();
                String key = (String)bucketCode + appType;
                Integer value = bucketBootList.size() * 20000;
                bucketBootNodeMapping.put(key, value);
            }
        }
        Object object = LOCK_OBJECT;
        synchronized (object) {
            isRefreshing = true;
            try {
                log.info("tenant flow controll cache refreshing......");
                Set<TenantInfo> tenantInfos = this.tenantInfoRepository.findByGatewayCode(this.gatewayCode);
                tenantConcurrentMapping.clear();
                totalWeightCountMapping = Maps.newConcurrentMap();
                if (CollectionUtils.isEmpty(tenantInfos)) {
                    return;
                }
                Map<String, List<TenantInfo>> tenantInfoGroups = tenantInfos.stream().collect(Collectors.groupingBy(item -> item.getBucketInfo().getBucketCode()));
                for (String bucketCode : tenantInfoGroups.keySet()) {
                    List<TenantInfo> tenantInfoItems = tenantInfoGroups.get(bucketCode);
                    if (CollectionUtils.isEmpty(tenantInfoItems)) continue;
                    int totalWeightCount = tenantInfoItems.stream().mapToInt(item -> item.getWeight() == null ? 5 : item.getWeight()).sum();
                    totalWeightCountMapping.put(bucketCode, totalWeightCount);
                }
                Map<String, Integer> tenantWeightMapping = tenantInfos.stream().collect(Collectors.toMap(TenantInfo::getTenantCode, TenantInfo::getWeight));
                for (BucketInfo bucketInfo : bucketInfos) {
                    Object[][] tenantDomainObjects = this.tenantDomainRepository.findByBucketInfo(bucketInfo.getId());
                    if (tenantDomainObjects == null || tenantDomainObjects.length == 0) {
                        log.error("\u672a\u53d1\u73b0\u4efb\u4f55\u6709\u6548\u7528\u6237\u4e0b\uff0c\u6709\u6548\u7684\u57df\u540d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!");
                    }
                    for (Object[] tenantDomainObjectItems : tenantDomainObjects) {
                        Integer tenantWeight;
                        String tenantCode;
                        Integer appType = tenantDomainObjectItems[0] == null ? null : (Integer)tenantDomainObjectItems[0];
                        String bucketCode = tenantDomainObjectItems[1] == null ? null : tenantDomainObjectItems[1].toString();
                        String string = tenantCode = tenantDomainObjectItems[2] == null ? null : tenantDomainObjectItems[2].toString();
                        if (appType == null || StringUtils.isBlank((CharSequence)bucketCode) || StringUtils.isBlank((CharSequence)tenantCode)) {
                            log.error("\u5728\u8fdb\u884c\u8d44\u6e90\u6876\u5206\u7ec4\u3001\u79df\u6237\u5206\u7ec4\u3001\u5e94\u7528\u7c7b\u578b\u5206\u7ec4\u65f6\uff0c\u53d1\u73b0\u4e3anull\u7684\u7ef4\u5ea6\uff1a" + appType + "|" + bucketCode + "|" + tenantCode);
                            continue;
                        }
                        Integer totalConcurrent = (Integer)bucketBootNodeMapping.get(bucketCode + appType);
                        if (totalConcurrent == null || (tenantWeight = tenantWeightMapping.get(tenantCode)) == null) continue;
                        String key = tenantCode + appType;
                        Integer totalWeightCount = totalWeightCountMapping.get(bucketCode);
                        totalWeightCount = totalWeightCount == null ? 1 : totalWeightCount;
                        Integer maxConcurrent = totalConcurrent * tenantWeight / totalWeightCount;
                        maxConcurrent = maxConcurrent == 0 ? 1 : maxConcurrent;
                        Semaphore value = new Semaphore(maxConcurrent);
                        log.info("" + tenantCode + " - apptype:" + appType + " max concurrent number = " + maxConcurrent);
                        tenantConcurrentMapping.put(key, value);
                    }
                }
            }
            finally {
                isRefreshing = false;
                LOCK_OBJECT.notifyAll();
            }
        }
    }

    public boolean isRefreshing() {
        return isRefreshing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncRefreshing() throws InterruptedException {
        if (isRefreshing) {
            Object object = LOCK_OBJECT;
            synchronized (object) {
                while (isRefreshing) {
                    LOCK_OBJECT.wait();
                }
            }
        }
    }

    public Semaphore findByTenantCode(String tenantCode, Integer appType) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || appType == null) {
            return null;
        }
        try {
            this.syncRefreshing();
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
        String key = tenantCode + appType;
        return tenantConcurrentMapping.get(key);
    }

    public Integer weightCount(String bucketCode) {
        if (StringUtils.isBlank((CharSequence)bucketCode)) {
            return 1;
        }
        try {
            this.syncRefreshing();
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return 0;
        }
        Integer totalWeightCount = totalWeightCountMapping.get(bucketCode);
        return totalWeightCount == null ? 1 : totalWeightCount;
    }

    public Integer weightCount(String tenantCode, Integer appType) {
        Semaphore semaphore = this.findByTenantCode(tenantCode, appType);
        if (semaphore == null) {
            return 0;
        }
        return semaphore.availablePermits();
    }

    static {
        isRefreshing = false;
    }
}

