/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.service.internal;

import com.bizunited.nebula.gateway.local.entity.GatewayInfo;
import com.bizunited.nebula.gateway.local.entity.TenantDomain;
import com.bizunited.nebula.gateway.local.entity.TenantInfo;
import com.bizunited.nebula.gateway.local.repository.GatewayInfoRepository;
import com.bizunited.nebula.gateway.local.repository.TenantInfoRepository;
import com.bizunited.nebula.gateway.sdk.service.TenantInfoVoService;
import com.bizunited.nebula.gateway.sdk.vo.TenantDomainVo;
import com.bizunited.nebula.gateway.sdk.vo.TenantInfoVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class TenantInfoVoServiceImpl
implements TenantInfoVoService {
    private static final Logger log = LoggerFactory.getLogger(TenantInfoVoServiceImpl.class);
    private volatile boolean isRefreshing = false;
    @Value(value="${gateway.code}")
    private String gatewayCode;
    @Value(value="${server.http.port:8081}")
    private int httpPort;
    @Value(value="${server.port:80}")
    private int serverPort;
    @Value(value="${server.ssl.enabled:false}")
    private boolean sslEnable;
    @Autowired
    private TenantInfoRepository tenantInfoRepository;
    @Autowired
    private GatewayInfoRepository gatewayInfoRepository;
    private Map<String, TenantInfoVo> tenantMapping = Maps.newConcurrentMap();
    private Set<String> tenantDisableSet = Sets.newConcurrentHashSet();

    public void refresh(String tenantCode) {
        TenantInfo tenantInfo = this.tenantInfoRepository.findByGatewayCodeAndTenantCode(this.gatewayCode, tenantCode);
        if (tenantInfo == null) {
            return;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Set<TenantInfo> tenantInfos = this.tenantInfoRepository.findDetailsByGatewayCode(this.gatewayCode);
        if (CollectionUtils.isEmpty(tenantInfos)) {
            this.tenantMapping.clear();
            return;
        }
        GatewayInfo gatewayInfo = this.gatewayInfoRepository.findByGatewayCode(this.gatewayCode);
        if (gatewayInfo == null) {
            return;
        }
        Object object = TenantInfoVoService.LOCK_OBJECT;
        synchronized (object) {
            this.isRefreshing = true;
            this.tenantMapping.clear();
            try {
                log.info("tenant cache refreshing......");
                for (TenantInfo tenantInfoItem : tenantInfos) {
                    List<TenantDomain> tenantDomains;
                    List tenantDomainVos;
                    String cTenantCode = tenantInfoItem.getTenantCode();
                    TenantInfoVo cTenantInfo = this.tenantMapping.get(cTenantCode);
                    if (cTenantInfo == null) {
                        cTenantInfo = new TenantInfoVo();
                        cTenantInfo.setTenantCode(tenantInfoItem.getTenantCode());
                        cTenantInfo.setTenantName(tenantInfoItem.getTenantName());
                        if (this.sslEnable) {
                            cTenantInfo.setGatewayPort(Integer.valueOf(this.serverPort));
                            cTenantInfo.setScheme("https");
                        } else {
                            cTenantInfo.setGatewayPort(Integer.valueOf(this.httpPort));
                            cTenantInfo.setScheme("http");
                        }
                        tenantDomainVos = Lists.newArrayList();
                        cTenantInfo.setTenantDomains(tenantDomainVos);
                        if (!tenantInfoItem.getState().booleanValue()) {
                            this.setDisable(tenantInfoItem.getTenantCode());
                        }
                        this.tenantMapping.put(tenantInfoItem.getTenantCode(), cTenantInfo);
                    } else {
                        tenantDomainVos = cTenantInfo.getTenantDomains();
                    }
                    if (CollectionUtils.isEmpty(tenantDomains = tenantInfoItem.getTenantDomains())) continue;
                    for (TenantDomain tenantDomain : tenantDomains) {
                        TenantDomainVo tenantDomainVo = new TenantDomainVo();
                        tenantDomainVo.setAppType(tenantDomain.getAppType());
                        tenantDomainVo.setDomain(tenantDomain.getDomain());
                        tenantDomainVo.setExternal(tenantDomain.getExternal());
                        tenantDomainVos.add(tenantDomainVo);
                    }
                }
            }
            finally {
                this.isRefreshing = false;
                TenantInfoVoService.LOCK_OBJECT.notifyAll();
            }
        }
    }

    public boolean isRefreshing() {
        return this.isRefreshing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TenantInfoVo findByTenantCode(String tenantCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        if (this.isRefreshing()) {
            Object object = TenantInfoVoService.LOCK_OBJECT;
            synchronized (object) {
                while (this.isRefreshing()) {
                    try {
                        TenantInfoVoService.LOCK_OBJECT.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error(e.getMessage(), (Throwable)e);
                        return null;
                    }
                }
            }
        }
        return this.tenantMapping.get(tenantCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TenantInfoVo> findByState(Integer status) {
        if (status == null) {
            return null;
        }
        if (this.isRefreshing()) {
            Object object = TenantInfoVoService.LOCK_OBJECT;
            synchronized (object) {
                while (this.isRefreshing()) {
                    try {
                        TenantInfoVoService.LOCK_OBJECT.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error(e.getMessage(), (Throwable)e);
                        return null;
                    }
                }
            }
        }
        ArrayList results = Lists.newArrayList();
        for (Map.Entry<String, TenantInfoVo> tenentInfoMappings : this.tenantMapping.entrySet()) {
            String tenantCode = tenentInfoMappings.getKey();
            TenantInfoVo currentTenantInfo = tenentInfoMappings.getValue();
            if (!this.validateStatus(tenantCode).booleanValue()) continue;
            results.add(currentTenantInfo);
        }
        return results;
    }

    public void setDisable(String tenantCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return;
        }
        this.tenantDisableSet.add(tenantCode);
    }

    public void setEnable(String tenantCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return;
        }
        this.tenantDisableSet.remove(tenantCode);
    }

    public Boolean validateStatus(String tenantCode) {
        Validate.notBlank((CharSequence)tenantCode, (String)"\u8fdb\u884c\u72b6\u6001\u5224\u65ad\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u79df\u6237\u7684\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        return !this.tenantDisableSet.contains(tenantCode);
    }
}

