/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.strategy;

import com.alibaba.fastjson.JSON;
import com.bizunited.nebula.gateway.sdk.strategy.DomainRouteGroupStrategy;
import com.bizunited.nebula.gateway.sdk.vo.GatewayDomainVo;
import com.bizunited.nebula.gateway.sdk.vo.TenantDomainVo;
import com.bizunited.nebula.gateway.sdk.vo.TenantInfoVo;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;

@Component(value="GroovyFileDomainRouteGroupStrategy")
public class GroovyFileDomainRouteGroupStrategy
implements DomainRouteGroupStrategy {
    private static final Logger log = LoggerFactory.getLogger(GroovyFileDomainRouteGroupStrategy.class);
    private ThreadLocal<String> groovyInvokeResultLocal = new ThreadLocal();
    private final String TENANT = "tenant";

    public int sort() {
        return -1;
    }

    public boolean strategy(ServerWebExchange exchange, GatewayDomainVo gatewayDomain) {
        HttpHeaders headers;
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        String result = this.invokeOne(serverHttpRequest, headers = serverHttpRequest.getHeaders());
        if (StringUtils.isBlank((CharSequence)result)) {
            return false;
        }
        this.groovyInvokeResultLocal.set(result);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String route(ServerWebExchange exchange, GatewayDomainVo gatewayDomain) {
        try {
            String string = this.groovyInvokeResultLocal.get();
            return string;
        }
        finally {
            this.groovyInvokeResultLocal.remove();
        }
    }

    private String invokeOne(ServerHttpRequest request, HttpHeaders headers) {
        try {
            log.info("---\u5f00\u59cb\u6267\u884cGroovy\u811a\u672c");
            List tenantList = request.getHeaders().get((Object)"tenant");
            if (CollectionUtils.isEmpty((Collection)tenantList)) {
                log.info("---\u5934\u4fe1\u606f\u65e0tenant\u4fe1\u606f");
                return null;
            }
            String encodeTenant = (String)tenantList.get(0);
            byte[] encodedBytes = Base64Utils.decodeFromString((String)encodeTenant);
            String decodeHeaders = new String(encodedBytes, StandardCharsets.UTF_8);
            TenantInfoVo tenantInfoVo = (TenantInfoVo)JSON.parseObject((String)decodeHeaders, TenantInfoVo.class);
            Boolean isCallInterface = false;
            List tenantDomains = tenantInfoVo.getTenantDomains();
            if (CollectionUtils.isEmpty((Collection)tenantDomains)) {
                return null;
            }
            String host = request.getURI().getHost();
            String url = request.getURI().getPath();
            for (TenantDomainVo tenantDomainVo : tenantDomains) {
                if (!StringUtils.equals((CharSequence)host, (CharSequence)tenantDomainVo.getDomain()) || tenantDomainVo.getExternal().booleanValue()) continue;
                isCallInterface = true;
            }
            if (!isCallInterface.booleanValue()) {
                return null;
            }
            String[] parts = url.split("/");
            if (parts.length < 2) {
                return null;
            }
            log.info("contains groupCode=" + parts[1]);
            return parts[1];
        }
        catch (RuntimeException e) {
            log.error("\u811a\u672c\u6267\u884c\u5f02\u5e38 e\uff1a{}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
            return null;
        }
    }
}

