/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.filter;

import com.bizunited.nebula.gateway.local.config.GatewayProperties;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsWebFilter;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.util.pattern.PathPatternParser;

@Configuration
public class CorsFilter {
    @Autowired
    private GatewayProperties gatewayProperties;

    @Bean
    @ConditionalOnProperty(prefix="gateway", name={"cross.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={CorsWebFilter.class})
    public CorsWebFilter getCorsFilter() {
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowedOriginPatterns((List)Lists.newArrayList((Object[])new String[]{"*"}));
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addExposedHeader("tenant");
        config.addExposedHeader("domain_source");
        config.addExposedHeader("jwt");
        config.setMaxAge(this.gatewayProperties.getCross().getMaxAge());
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource(new PathPatternParser());
        source.registerCorsConfiguration("/**", config);
        return new CorsWebFilter((CorsConfigurationSource)source);
    }
}

