/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.filter;

import com.bizunited.nebula.gateway.local.config.GatewayProperties;
import java.util.UUID;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import reactor.core.publisher.Mono;

class HeadResponseDecorator
extends ServerHttpResponseDecorator {
    private GatewayProperties gatewayProperties;

    public HeadResponseDecorator(ServerHttpResponse delegate, GatewayProperties gatewayProperties) {
        super(delegate);
        this.gatewayProperties = gatewayProperties;
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        ServerHttpResponse response = this.getDelegate();
        HttpHeaders headers = response.getHeaders();
        headers.remove((Object)"tenant");
        headers.remove((Object)"domain_source");
        if (!headers.containsKey((Object)"Server")) {
            headers.add("Server", this.gatewayProperties.getName());
            headers.add("Version", this.gatewayProperties.getVersion());
        }
        if (!headers.containsKey((Object)"X-TRACE-ID")) {
            headers.add("X-TRACE-ID", UUID.randomUUID().toString());
        }
        return super.writeWith(body);
    }
}

