/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.filter;

import com.bizunited.nebula.gateway.local.config.GatewayProperties;
import com.bizunited.nebula.gateway.local.filter.AbstractFilter;
import com.bizunited.nebula.gateway.local.filter.FlowControlResponseDecorator;
import com.bizunited.nebula.gateway.sdk.service.GatewayDomainVoService;
import com.bizunited.nebula.gateway.sdk.service.TenantInfoFlowService;
import com.bizunited.nebula.gateway.sdk.service.TenantInfoVoService;
import com.bizunited.nebula.gateway.sdk.strategy.DomainRouteGroupStrategy;
import com.bizunited.nebula.gateway.sdk.vo.GatewayDomainVo;
import com.bizunited.nebula.gateway.sdk.vo.GatewayRouteNodeVo;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class LoadBalancerFilter
extends AbstractFilter
implements GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(LoadBalancerFilter.class);
    private static final String GATEWAY_REQUEST_URL_ATTR = "org.springframework.cloud.gateway.support.ServerWebExchangeUtils.gatewayRequestUrl";
    private static final int LOAD_BALANCER_CLIENT_FILTER_ORDER = 10100;
    @Autowired
    private GatewayDomainVoService gatewayDomainVoService;
    @Autowired
    private TenantInfoVoService tenantInfoVoService;
    @Autowired
    private TenantInfoFlowService tenantInfoFlowService;
    @Autowired(required=false)
    private List<DomainRouteGroupStrategy> domainRouteGroupStrategys;
    @Autowired
    private GatewayProperties gatewayProperties;

    public int getOrder() {
        return 10100;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        GatewayRouteNodeVo c;
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        log.debug("ready to Load Balancer sourceUrl = " + serverHttpRequest.getURI());
        String hostName = serverHttpRequest.getURI().getHost();
        GatewayDomainVo gatewayDomain = this.existInLoadBalancerDomain(hostName);
        if (gatewayDomain == null) {
            return chain.filter(exchange);
        }
        Semaphore semaphore = null;
        try {
            semaphore = this.currentLimiting(exchange, chain);
        }
        catch (RuntimeException e) {
            DataBuffer buffer = this.write408(exchange);
            return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
        }
        URI sourceUri = serverHttpRequest.getURI();
        String scheme = sourceUri.getScheme();
        String whitelistTargetHost = super.matchWhitelist(hostName);
        if (StringUtils.isNotBlank((CharSequence)whitelistTargetHost)) {
            try {
                URI targetUri = new URI(whitelistTargetHost);
                URI resultTargetUri = this.toTargetUri(sourceUri, targetUri.getScheme(), targetUri.getPort(), targetUri.getHost());
                return this.doForward(exchange, chain, resultTargetUri, null);
            }
            catch (URISyntaxException e) {
                DataBuffer buffer = this.write500(exchange, "targetHost error");
                return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
            }
        }
        List gatewayRouteNodes = Lists.newArrayList();
        Map gatewayRouteNodeMapping = gatewayDomain.getGatewayRouteNodes();
        String balanceFlag = "default";
        if (!CollectionUtils.isEmpty((Map)gatewayRouteNodeMapping) && !CollectionUtils.isEmpty(this.domainRouteGroupStrategys)) {
            if (this.gatewayProperties.getBalanceGroupRoute().booleanValue()) {
                for (DomainRouteGroupStrategy domainRouteGroupStrategy : this.domainRouteGroupStrategys) {
                    if (!domainRouteGroupStrategy.strategy(exchange, gatewayDomain) || !StringUtils.isNotBlank((CharSequence)(balanceFlag = domainRouteGroupStrategy.route(exchange, gatewayDomain)))) continue;
                    if (StringUtils.equals((CharSequence)balanceFlag, (CharSequence)"default")) {
                        log.warn("===== \u5728\u8fdb\u884c\u8d1f\u8f7d\u5747\u8861\u8def\u7531\u65f6\uff0c\u53d1\u73b0balanceFlag\u4e3adefault\u7684\u60c5\u51b5  =====");
                    }
                    if (CollectionUtils.isEmpty(gatewayRouteNodes = (List)gatewayRouteNodeMapping.get(balanceFlag))) continue;
                    break;
                }
            } else {
                gatewayRouteNodes = (List)gatewayRouteNodeMapping.get(balanceFlag);
            }
        }
        if (CollectionUtils.isEmpty((Collection)gatewayRouteNodes)) {
            DataBuffer buffer = this.write500(exchange, "Route Node error");
            return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
        }
        if (gatewayRouteNodes.size() == 1) {
            c = (GatewayRouteNodeVo)gatewayRouteNodes.get(0);
        } else {
            int randomIndex = ThreadLocalRandom.current().nextInt(100) % gatewayRouteNodes.size();
            c = (GatewayRouteNodeVo)gatewayRouteNodes.get(randomIndex);
        }
        String targetIp = c.getIp();
        Integer targetPort = c.getPort();
        String targetAgreement = StringUtils.isBlank((CharSequence)c.getAgreement()) ? "http" : c.getAgreement();
        URI targetUri = null;
        targetUri = StringUtils.equalsIgnoreCase((CharSequence)scheme, (CharSequence)"https") && StringUtils.equalsIgnoreCase((CharSequence)targetAgreement, (CharSequence)"http") ? this.httpsToHttp(sourceUri, targetPort, targetIp) : (StringUtils.equalsIgnoreCase((CharSequence)scheme, (CharSequence)"http") && StringUtils.equalsIgnoreCase((CharSequence)targetAgreement, (CharSequence)"https") ? this.httpToHttps(sourceUri, targetPort, targetIp) : this.toTargetUri(sourceUri, sourceUri.getScheme(), targetPort, targetIp));
        log.debug("Load Balancer targetUri = " + targetUri);
        if (targetUri == null) {
            DataBuffer buffer = this.write500(exchange, "target uri error");
            return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
        }
        return this.doForward(exchange, chain, targetUri, semaphore);
    }

    private Semaphore currentLimiting(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        String hostName = serverHttpRequest.getURI().getHost();
        if (StringUtils.isNotBlank((CharSequence)super.matchWhitelist(hostName))) {
            return null;
        }
        GatewayDomainVo gatewayDomain = this.gatewayDomainVoService.findByExternalDomain(hostName);
        if (gatewayDomain != null) {
            return null;
        }
        gatewayDomain = this.gatewayDomainVoService.findByInternalDomain(hostName);
        Validate.notNull((Object)gatewayDomain, (String)"gatewayDomain not be null\uff01\uff01", (Object[])new Object[0]);
        String tenantCode = gatewayDomain.getTenantCode();
        Integer appType = gatewayDomain.getAppType();
        if (!this.tenantInfoVoService.validateStatus(tenantCode).booleanValue()) {
            log.debug("tenant code " + tenantCode + " is disable!!");
            throw new IllegalArgumentException("tenant code " + tenantCode + " is disable!!");
        }
        Semaphore semaphore = this.tenantInfoFlowService.findByTenantCode(tenantCode, appType);
        if (semaphore == null) {
            log.error("tenant code " + tenantCode + " has error semaphore !!");
            throw new IllegalArgumentException("tenant code " + tenantCode + " has error semaphore !!");
        }
        try {
            boolean success;
            if (ThreadLocalRandom.current().nextFloat() < this.gatewayProperties.getSamplingRate().floatValue()) {
                log.info("befor (" + tenantCode + "|" + appType + ") semaphore count = " + semaphore.availablePermits());
            }
            if (!(success = semaphore.tryAcquire(1L, TimeUnit.SECONDS))) {
                log.error("has error semaphore !!");
                throw new IllegalArgumentException("has error semaphore !!");
            }
            return semaphore;
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private DataBuffer write408(ServerWebExchange exchange) {
        ServerHttpResponse serverHttpResponse = exchange.getResponse();
        serverHttpResponse.setStatusCode(HttpStatus.REQUEST_TIMEOUT);
        DataBuffer buffer = exchange.getResponse().bufferFactory().wrap("".getBytes());
        return buffer;
    }

    private DataBuffer write500(ServerWebExchange exchange, String errorMsg) {
        ServerHttpResponse serverHttpResponse = exchange.getResponse();
        serverHttpResponse.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
        DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(errorMsg.getBytes());
        return buffer;
    }

    private URI httpToHttps(URI sourceUri, Integer targetPort, String targetHost) {
        try {
            String sourceQuery = sourceUri.getQuery();
            String targetQuery = null;
            if (StringUtils.isNotBlank((CharSequence)sourceQuery)) {
                targetQuery = this.analysisQueryParams(sourceQuery);
            }
            URI targetUri = new URI("https", sourceUri.getUserInfo(), targetHost, targetPort, sourceUri.getPath(), null, sourceUri.getFragment());
            if (StringUtils.isNotBlank((CharSequence)sourceQuery)) {
                return new URI(StringUtils.join((Object[])new String[]{targetUri.toString(), "?", targetQuery}));
            }
            return new URI(targetUri.toString());
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private URI httpsToHttp(URI sourceUri, Integer targetPort, String targetHost) {
        try {
            String sourceQuery = sourceUri.getQuery();
            String targetQuery = null;
            if (StringUtils.isNotBlank((CharSequence)sourceQuery)) {
                targetQuery = this.analysisQueryParams(sourceQuery);
            }
            URI targetUri = new URI("http", sourceUri.getUserInfo(), targetHost, targetPort, sourceUri.getPath(), null, sourceUri.getFragment());
            if (StringUtils.isNotBlank((CharSequence)sourceQuery)) {
                return new URI(StringUtils.join((Object[])new String[]{targetUri.toString(), "?", targetQuery}));
            }
            return new URI(targetUri.toString());
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Mono<Void> doForward(ServerWebExchange exchange, GatewayFilterChain chain, URI targetUri, Semaphore semaphore) {
        exchange.getAttributes().put(GATEWAY_REQUEST_URL_ATTR, targetUri);
        if (semaphore != null) {
            exchange.getAttributes().put("semaphore", semaphore);
        }
        return chain.filter(exchange.mutate().response((ServerHttpResponse)new FlowControlResponseDecorator(exchange.getResponse(), semaphore)).build());
    }
}

