/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.filter;

import com.bizunited.nebula.gateway.local.config.GatewayProperties;
import com.bizunited.nebula.gateway.local.utils.FileTypeEnum;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class StaticResourcesFilter
implements GlobalFilter,
Ordered {
    @Autowired
    private GatewayProperties gatewayProperties;

    public int getOrder() {
        return -10;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        URI sourceUrl = serverHttpRequest.getURI();
        String hostName = sourceUrl.getHost();
        GatewayProperties.Static resources = this.gatewayProperties.getResources();
        CharSequence[] domains = resources.getDomains();
        String location = resources.getLocation();
        String path = resources.getPath();
        if (StringUtils.isBlank((CharSequence)location) || StringUtils.isBlank((CharSequence)path) || domains == null || domains.length == 0) {
            return chain.filter(exchange);
        }
        try {
            if (!StringUtils.equalsAny((CharSequence)hostName, (CharSequence[])domains)) {
                return chain.filter(exchange);
            }
            String urlPath = sourceUrl.getPath();
            if (StringUtils.indexOf((CharSequence)urlPath, (CharSequence)path) != 0) {
                return chain.filter(exchange);
            }
            String filename = StringUtils.substringAfterLast((String)urlPath, (String)"/");
            if (StringUtils.isBlank((CharSequence)filename)) {
                return chain.filter(exchange);
            }
            String fileSuffix = StringUtils.substringAfter((String)filename, (String)".");
            if (StringUtils.isBlank((CharSequence)fileSuffix)) {
                return chain.filter(exchange);
            }
            if (StringUtils.indexOf((CharSequence)urlPath, (CharSequence)".") != -1) {
                String suffixs = StringUtils.substringAfterLast((String)urlPath, (String)".");
                CharSequence[] excludeSuffixs = this.gatewayProperties.getExcludeSuffixs();
                if (excludeSuffixs != null && excludeSuffixs.length > 0 && StringUtils.equalsAnyIgnoreCase((CharSequence)suffixs, (CharSequence[])excludeSuffixs)) {
                    return chain.filter(exchange);
                }
            }
            String relativePath = StringUtils.substringAfter((String)urlPath, (String)path);
            File rootFile = new File(location);
            if (!rootFile.exists() || !rootFile.isDirectory()) {
                DataBuffer buffer = this.write404(exchange);
                return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
            }
            File absoluteFile = new File(rootFile, relativePath);
            ByteArrayOutputStream fileContentOutputStream = new ByteArrayOutputStream();
            FileUtils.copyFile((File)absoluteFile, (OutputStream)fileContentOutputStream);
            DataBuffer buffer = this.writeResourceContent(exchange, fileContentOutputStream, StringUtils.join((Object[])new String[]{".", fileSuffix}));
            return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
        }
        catch (IOException | RuntimeException e) {
            DataBuffer buffer = this.write404(exchange);
            return exchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
        }
    }

    private DataBuffer write404(ServerWebExchange exchange) {
        ServerHttpResponse serverHttpResponse = exchange.getResponse();
        serverHttpResponse.setStatusCode(HttpStatus.NOT_FOUND);
        DataBuffer buffer = exchange.getResponse().bufferFactory().wrap("".getBytes());
        return buffer;
    }

    private DataBuffer writeResourceContent(ServerWebExchange exchange, ByteArrayOutputStream fileContentOutputStream, String fileSuffix) {
        ServerHttpResponse serverHttpResponse = exchange.getResponse();
        byte[] resourceContent = fileContentOutputStream.toByteArray();
        serverHttpResponse.setStatusCode(HttpStatus.OK);
        HttpHeaders httpHeaders = serverHttpResponse.getHeaders();
        String contentType = FileTypeEnum.mappingContentType(fileSuffix);
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = "text/plain";
        }
        httpHeaders.set("Content-Type", contentType + "; charset=UTF-8");
        httpHeaders.setContentLength((long)resourceContent.length);
        httpHeaders.setDate(new Date().getTime());
        httpHeaders.setContentLanguage(Locale.CHINA);
        DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(resourceContent);
        return buffer;
    }
}

