/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.repository.internal;

import com.bizunited.nebula.gateway.local.dto.InterfaceMonitorMappingDto;
import com.bizunited.nebula.gateway.local.entity.InterfaceMonitorMapping;
import com.bizunited.nebula.gateway.local.repository.internal.InterfaceMonitorMappingRepositoryCustom;
import com.bizunited.nebula.gateway.local.repository.internal.PageRepositoryImpl;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="_InterfaceMonitorMappingRepositoryCustomImpl")
public class InterfaceMonitorMappingRepositoryCustomImpl
implements InterfaceMonitorMappingRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<InterfaceMonitorMapping> findByConditions(Pageable pageable, InterfaceMonitorMappingDto conditions) {
        String targetDomain;
        String sourceDomain;
        Integer invokeType;
        String groupCode;
        String bucketCode;
        if (conditions == null) {
            conditions = new InterfaceMonitorMappingDto();
        }
        StringBuilder hql = new StringBuilder("from InterfaceMonitorMapping imm where 1 = 1");
        StringBuilder countHql = new StringBuilder("select count(*) from InterfaceMonitorMapping imm where 1 = 1");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String tenantCode = conditions.getTenantCode();
        if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
            condition.append(" AND imm.tenantCode = :tenantCode ");
            parameters.put("tenantCode", tenantCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(bucketCode = conditions.getBucketCode()))) {
            condition.append(" AND imm.bucketCode = :bucketCode ");
            parameters.put("bucketCode", bucketCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(groupCode = conditions.getGroupCode()))) {
            condition.append(" AND imm.groupCode = :groupCode ");
            parameters.put("groupCode", groupCode);
        }
        if ((invokeType = conditions.getInvokeType()) != null) {
            condition.append(" AND imm.invokeType = :invokeType ");
            parameters.put("invokeType", invokeType);
        }
        if (StringUtils.isNotBlank((CharSequence)(sourceDomain = conditions.getSourceDomain()))) {
            condition.append(" AND imm.sourceDomain like CONCAT('%',:sourceDomain,'%') ");
            parameters.put("sourceDomain", sourceDomain);
        }
        if (StringUtils.isNotBlank((CharSequence)(targetDomain = conditions.getTargetDomain()))) {
            condition.append(" AND imm.targetDomain like CONCAT('%',:targetDomain,'%') ");
            parameters.put("targetDomain", targetDomain);
        }
        hql.append((CharSequence)condition).append(" order by imm.targetDomain desc ");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
    }
}

