/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.service.internal;

import com.bizunited.nebula.gateway.local.entity.BucketBoot;
import com.bizunited.nebula.gateway.local.entity.BucketInfo;
import com.bizunited.nebula.gateway.local.entity.BucketNodejs;
import com.bizunited.nebula.gateway.local.entity.GatewayInfo;
import com.bizunited.nebula.gateway.local.entity.TenantDomain;
import com.bizunited.nebula.gateway.local.entity.TenantInfo;
import com.bizunited.nebula.gateway.local.repository.BucketInfoRepository;
import com.bizunited.nebula.gateway.local.repository.TenantInfoRepository;
import com.bizunited.nebula.gateway.sdk.service.GatewayDomainVoService;
import com.bizunited.nebula.gateway.sdk.vo.GatewayDomainVo;
import com.bizunited.nebula.gateway.sdk.vo.GatewayRouteNodeVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class GatewayDomainVoServiceImpl
implements GatewayDomainVoService {
    private static final Logger log = LoggerFactory.getLogger(GatewayDomainVoServiceImpl.class);
    private volatile boolean isRefreshing = false;
    @Value(value="${gateway.code}")
    private String gatewayCode;
    @Autowired
    private BucketInfoRepository bucketInfoRepository;
    @Autowired
    private TenantInfoRepository tenantInfoRepository;
    private Map<String, GatewayDomainVo> externalRouteMapping = Maps.newConcurrentMap();
    private Map<String, GatewayDomainVo> internalRouteMapping = Maps.newConcurrentMap();

    public boolean isRefreshing() {
        return this.isRefreshing;
    }

    public void refresh(String bucketCode) {
        log.info("gateway domain cache refresh ...... ");
        BucketInfo bucketInfo = this.bucketInfoRepository.findDetailsByBucketCode(bucketCode);
        if (bucketInfo == null) {
            return;
        }
        GatewayInfo gatewayInfo = bucketInfo.getGatewayInfo();
        if (gatewayInfo == null) {
            return;
        }
        String gatewayCode = gatewayInfo.getGatewayCode();
        if (!StringUtils.equals((CharSequence)gatewayCode, (CharSequence)this.gatewayCode)) {
            log.info("\u6536\u5230BucketRouteNode.refresh\u4e8b\u4ef6\uff0c\u4f46\u662f\u6307\u5b9a\u7684\u8d44\u6e90\u6876{}\u5e76\u4e0d\u7531\u672c\u7f51\u5173{}\u8d1f\u8d23\uff0c\u6545\u5ffd\u7565\u672c\u6b21\u5904\u7406", (Object)bucketCode, (Object)this.gatewayCode);
            return;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Set<TenantInfo> tenants = this.tenantInfoRepository.findDetailsByGatewayCode(this.gatewayCode);
        if (CollectionUtils.isEmpty(tenants)) {
            this.externalRouteMapping.clear();
            this.internalRouteMapping.clear();
            log.info("\u672a\u627e\u5230\u7279\u5b9a\u7684\u7f51\u5173{}\u4e2d\u6709\u4efb\u4f55\u670d\u52a1\u7684\u79df\u6237\u4fe1\u606f\uff0c\u672c\u6b21\u7f51\u5173\u8def\u7531\u5237\u65b0\u88ab\u5ffd\u7565", (Object)this.gatewayCode);
            return;
        }
        Set<BucketInfo> bucketInfos = this.bucketInfoRepository.findDetailsByGatewayCode(this.gatewayCode);
        if (CollectionUtils.isEmpty(bucketInfos)) {
            this.externalRouteMapping.clear();
            this.internalRouteMapping.clear();
            return;
        }
        Object object = GatewayDomainVoService.LOCK_OBJECT;
        synchronized (object) {
            this.isRefreshing = true;
            this.externalRouteMapping.clear();
            this.internalRouteMapping.clear();
            try {
                log.info("gateway cache refreshing......");
                HashMap intrnalMapping = Maps.newHashMap();
                HashMap externalMapping = Maps.newHashMap();
                for (TenantInfo tenant : tenants) {
                    List<TenantDomain> tenantDomains = tenant.getTenantDomains();
                    BucketInfo currentBucketInfo = tenant.getBucketInfo();
                    if (CollectionUtils.isEmpty(tenantDomains) || currentBucketInfo == null) continue;
                    String currentBucketCode = currentBucketInfo.getBucketCode();
                    tenantDomains.stream().forEach(tenantDomainItem -> {
                        boolean external = tenantDomainItem.getExternal();
                        Integer appType = tenantDomainItem.getAppType();
                        String domain = tenantDomainItem.getDomain();
                        String tenantCode = tenantDomainItem.getTenantInfo().getTenantCode();
                        String tenantName = tenantDomainItem.getTenantInfo().getTenantName();
                        if (external) {
                            externalMapping.put(domain, new DomainMapping(currentBucketCode, appType, tenantCode, tenantName));
                        } else {
                            intrnalMapping.put(domain, new DomainMapping(currentBucketCode, appType, tenantCode, tenantName));
                        }
                    });
                }
                Map bucketInfoMapping = bucketInfos.stream().collect(Collectors.toMap(BucketInfo::getBucketCode, Function.identity()));
                if (!CollectionUtils.isEmpty((Map)externalMapping)) {
                    externalMapping.entrySet().forEach(item -> this.mappingRoutes(true, (Map.Entry<String, DomainMapping>)item, bucketInfoMapping, this.externalRouteMapping));
                }
                if (!CollectionUtils.isEmpty((Map)intrnalMapping)) {
                    intrnalMapping.entrySet().forEach(item -> this.mappingRoutes(false, (Map.Entry<String, DomainMapping>)item, bucketInfoMapping, this.internalRouteMapping));
                }
            }
            finally {
                this.isRefreshing = false;
                GatewayDomainVoService.LOCK_OBJECT.notifyAll();
            }
        }
    }

    private void mappingRoutes(boolean external, Map.Entry<String, DomainMapping> item, Map<String, BucketInfo> bucketInfoMapping, Map<String, GatewayDomainVo> routeMapping) {
        String domain = item.getKey();
        DomainMapping domainMapping = item.getValue();
        int appType = domainMapping.getAppType();
        BucketInfo bucketInfoItem = bucketInfoMapping.get(domainMapping.getBucketInfoCode());
        Set<BucketNodejs> bucketNodejss = bucketInfoItem.getBucketNodejss();
        Set<BucketBoot> bucketBoots = bucketInfoItem.getBucketBoots();
        GatewayDomainVo gatewayDomainVo = new GatewayDomainVo();
        gatewayDomainVo.setAppType(Integer.valueOf(appType));
        gatewayDomainVo.setDomain(domain);
        gatewayDomainVo.setExternal(Boolean.valueOf(external));
        gatewayDomainVo.setTenantCode(domainMapping.getTenantCode());
        gatewayDomainVo.setTenantName(domainMapping.getTenantName());
        if (external) {
            List bucketNodejssforAppType = bucketNodejss.stream().filter(i -> i.getAppType() == appType).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bucketNodejssforAppType)) {
                return;
            }
            ArrayList gatewayDomains = Lists.newArrayList();
            for (BucketNodejs bucketNodejsItem : bucketNodejssforAppType) {
                GatewayRouteNodeVo gatewayRouteNodeVo = new GatewayRouteNodeVo();
                gatewayRouteNodeVo.setIp(bucketNodejsItem.getIp());
                gatewayRouteNodeVo.setPort(bucketNodejsItem.getPort());
                gatewayRouteNodeVo.setAgreement(StringUtils.isBlank((CharSequence)bucketNodejsItem.getAgreement()) ? "http" : bucketNodejsItem.getAgreement());
                gatewayRouteNodeVo.setGroupCode(StringUtils.isBlank((CharSequence)bucketNodejsItem.getGroupCode()) ? "default" : bucketNodejsItem.getGroupCode());
                gatewayDomains.add(gatewayRouteNodeVo);
            }
            if (CollectionUtils.isEmpty((Collection)gatewayDomains)) {
                gatewayDomainVo.setGatewayRouteNodes(null);
            } else {
                gatewayDomainVo.setGatewayRouteNodes(gatewayDomains.stream().collect(Collectors.groupingBy(GatewayRouteNodeVo::getGroupCode)));
            }
            routeMapping.put(domain, gatewayDomainVo);
        } else {
            List bucketBootsforAppType = bucketBoots.stream().filter(i -> i.getAppType() == appType).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bucketBootsforAppType)) {
                return;
            }
            ArrayList gatewayDomains = Lists.newArrayList();
            for (BucketBoot bucketBootItem : bucketBootsforAppType) {
                GatewayRouteNodeVo gatewayRouteNodeVo = new GatewayRouteNodeVo();
                gatewayRouteNodeVo.setIp(bucketBootItem.getIp());
                gatewayRouteNodeVo.setPort(bucketBootItem.getPort());
                gatewayRouteNodeVo.setAgreement(StringUtils.isBlank((CharSequence)bucketBootItem.getAgreement()) ? "http" : bucketBootItem.getAgreement());
                gatewayRouteNodeVo.setGroupCode(StringUtils.isBlank((CharSequence)bucketBootItem.getGroupCode()) ? "default" : bucketBootItem.getGroupCode());
                gatewayDomains.add(gatewayRouteNodeVo);
            }
            if (CollectionUtils.isEmpty((Collection)gatewayDomains)) {
                gatewayDomainVo.setGatewayRouteNodes(null);
            } else {
                gatewayDomainVo.setGatewayRouteNodes(gatewayDomains.stream().collect(Collectors.groupingBy(GatewayRouteNodeVo::getGroupCode)));
            }
            routeMapping.put(domain, gatewayDomainVo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GatewayDomainVo findByExternalDomain(String domain) {
        if (StringUtils.isBlank((CharSequence)domain)) {
            return null;
        }
        if (this.isRefreshing()) {
            Object object = GatewayDomainVoService.LOCK_OBJECT;
            synchronized (object) {
                while (this.isRefreshing()) {
                    try {
                        GatewayDomainVoService.LOCK_OBJECT.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error(e.getMessage(), (Throwable)e);
                        return null;
                    }
                }
            }
        }
        return this.externalRouteMapping.get(domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GatewayDomainVo findByInternalDomain(String domain) {
        if (StringUtils.isBlank((CharSequence)domain)) {
            return null;
        }
        if (this.isRefreshing()) {
            Object object = GatewayDomainVoService.LOCK_OBJECT;
            synchronized (object) {
                while (this.isRefreshing()) {
                    try {
                        GatewayDomainVoService.LOCK_OBJECT.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error(e.getMessage(), (Throwable)e);
                        return null;
                    }
                }
            }
        }
        return this.internalRouteMapping.get(domain);
    }

    private class DomainMapping {
        private String bucketInfoCode;
        private Integer appType;
        private String tenantCode;
        private String tenantName;

        public DomainMapping(String bucketInfoCode, Integer appType, String tenantCode, String tenantName) {
            this.bucketInfoCode = bucketInfoCode;
            this.appType = appType;
            this.tenantCode = tenantCode;
            this.tenantName = tenantName;
        }

        public String getBucketInfoCode() {
            return this.bucketInfoCode;
        }

        public Integer getAppType() {
            return this.appType;
        }

        public String getTenantCode() {
            return this.tenantCode;
        }

        public String getTenantName() {
            return this.tenantName;
        }

        public void setBucketInfoCode(String bucketInfoCode) {
            this.bucketInfoCode = bucketInfoCode;
        }

        public void setAppType(Integer appType) {
            this.appType = appType;
        }

        public void setTenantCode(String tenantCode) {
            this.tenantCode = tenantCode;
        }

        public void setTenantName(String tenantName) {
            this.tenantName = tenantName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DomainMapping)) {
                return false;
            }
            DomainMapping other = (DomainMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$appType = this.getAppType();
            Integer other$appType = other.getAppType();
            if (this$appType == null ? other$appType != null : !((Object)this$appType).equals(other$appType)) {
                return false;
            }
            String this$bucketInfoCode = this.getBucketInfoCode();
            String other$bucketInfoCode = other.getBucketInfoCode();
            if (this$bucketInfoCode == null ? other$bucketInfoCode != null : !this$bucketInfoCode.equals(other$bucketInfoCode)) {
                return false;
            }
            String this$tenantCode = this.getTenantCode();
            String other$tenantCode = other.getTenantCode();
            if (this$tenantCode == null ? other$tenantCode != null : !this$tenantCode.equals(other$tenantCode)) {
                return false;
            }
            String this$tenantName = this.getTenantName();
            String other$tenantName = other.getTenantName();
            return !(this$tenantName == null ? other$tenantName != null : !this$tenantName.equals(other$tenantName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DomainMapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $appType = this.getAppType();
            result = result * 59 + ($appType == null ? 43 : ((Object)$appType).hashCode());
            String $bucketInfoCode = this.getBucketInfoCode();
            result = result * 59 + ($bucketInfoCode == null ? 43 : $bucketInfoCode.hashCode());
            String $tenantCode = this.getTenantCode();
            result = result * 59 + ($tenantCode == null ? 43 : $tenantCode.hashCode());
            String $tenantName = this.getTenantName();
            result = result * 59 + ($tenantName == null ? 43 : $tenantName.hashCode());
            return result;
        }

        public String toString() {
            return "GatewayDomainVoServiceImpl.DomainMapping(bucketInfoCode=" + this.getBucketInfoCode() + ", appType=" + this.getAppType() + ", tenantCode=" + this.getTenantCode() + ", tenantName=" + this.getTenantName() + ")";
        }
    }
}

