/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.service.internal;

import com.bizunited.nebula.gateway.local.entity.GatewayInfo;
import com.bizunited.nebula.gateway.local.repository.GatewayInfoRepository;
import com.bizunited.nebula.gateway.local.service.GatewayInfoService;
import java.util.Date;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GatewayInfoServiceImpl
implements GatewayInfoService {
    @Autowired
    private GatewayInfoRepository gatewayInfoRepository;

    @Override
    @Transactional
    public GatewayInfo create(GatewayInfo gatewayInfo) {
        Validate.notNull((Object)gatewayInfo, (String)"\u9519\u8bef\u7684\u7f51\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        gatewayInfo.setId(null);
        String gatewayCode = gatewayInfo.getGatewayCode();
        GatewayInfo currentGatewayInfo = this.gatewayInfoRepository.findByGatewayCode(gatewayCode);
        Validate.isTrue((currentGatewayInfo == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u4f7f\u7528\u7684\u7f51\u5173\u7f16\u53f7\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String remark = gatewayInfo.getRemark();
        Validate.notBlank((CharSequence)remark, (String)"\u5f53\u524d\u7f51\u5173\u7684\u5907\u6ce8\u8bf4\u660e\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        Date now = new Date();
        gatewayInfo.setCreateAccount("admin");
        gatewayInfo.setCreateTime(now);
        gatewayInfo.setModifyAccount("admin");
        gatewayInfo.setModifyTime(now);
        this.gatewayInfoRepository.save(gatewayInfo);
        return gatewayInfo;
    }

    @Override
    @Transactional
    public GatewayInfo update(GatewayInfo gatewayInfo) {
        Validate.notNull((Object)gatewayInfo, (String)"\u9519\u8bef\u7684\u7f51\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String id = gatewayInfo.getId();
        Validate.notBlank((CharSequence)id, (String)"\u7f51\u5173\u4fe1\u606f\u7684id\u7f16\u53f7\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        GatewayInfo currentGatewayInfo = this.gatewayInfoRepository.findById(id).orElse(null);
        Validate.notNull((Object)currentGatewayInfo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String remark = gatewayInfo.getRemark();
        Validate.notBlank((CharSequence)remark, (String)"\u5f53\u524d\u7f51\u5173\u7684\u5907\u6ce8\u8bf4\u660e\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        currentGatewayInfo.setRemark(gatewayInfo.getRemark());
        Date now = new Date();
        currentGatewayInfo.setModifyAccount("admin");
        currentGatewayInfo.setModifyTime(now);
        currentGatewayInfo.setBucketInfos(null);
        this.gatewayInfoRepository.save(currentGatewayInfo);
        return currentGatewayInfo;
    }

    @Override
    public List<GatewayInfo> findAll() {
        List gateways = this.gatewayInfoRepository.findAll();
        return gateways;
    }
}

