/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.service.internal;

import com.bizunited.nebula.gateway.local.dto.LogInfoConditionDto;
import com.bizunited.nebula.gateway.local.log.LogInfo;
import com.bizunited.nebula.gateway.local.service.LogInfoEsService;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class LogInfoEsServiceImpl
implements LogInfoEsService {
    @Autowired
    private ElasticsearchRestTemplate esTemplate;

    @Override
    public SearchHits<LogInfo> findByConditions(LogInfoConditionDto condition, Pageable pageable) {
        if (condition == null) {
            condition = new LogInfoConditionDto();
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)condition.getLogId())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)condition.getLogId()).field("logId"));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getTenantCode())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)condition.getTenantCode()).field("tenantCode"));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getMonitorName())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"monitorName", (Object)condition.getMonitorName()));
        }
        if (condition.getRequestTimeStart() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"requestTime").gte((Object)condition.getRequestTimeStart()));
        }
        if (condition.getRequestTimeEnd() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"requestTime").lte((Object)condition.getRequestTimeEnd()));
        }
        if (condition.getInvokeType() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"invokeType", (Object)condition.getInvokeType()));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getTargetDomain())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"targetDomain", (Object)condition.getTargetDomain()));
        }
        if (condition.getResponseTimeStart() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"responseTime").gte((Object)condition.getResponseTimeStart()));
        }
        if (condition.getResponseTimeEnd() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"responseTime").lte((Object)condition.getResponseTimeEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getResponseCode())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"responseCode", (Object)condition.getResponseCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getContent())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)condition.getContent(), (String[])new String[]{"requestParam", "requestHeaders", "requestBody", "responseBody", "responseCookies", "responseHeaders"}));
        }
        NativeSearchQuery nativeSearchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)queryBuilder).withPageable(pageable).withSorts(new SortBuilder[]{SortBuilders.fieldSort((String)"requestTime").order(SortOrder.DESC)}).build();
        return this.esTemplate.search((Query)nativeSearchQuery, LogInfo.class);
    }
}

