/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.local.service.internal;

import com.bizunited.nebula.gateway.local.entity.BucketBoot;
import com.bizunited.nebula.gateway.local.entity.BucketInfo;
import com.bizunited.nebula.gateway.local.entity.BucketNodejs;
import com.bizunited.nebula.gateway.local.entity.TenantDomain;
import com.bizunited.nebula.gateway.local.entity.TenantInfo;
import com.bizunited.nebula.gateway.local.repository.BucketInfoRepository;
import com.bizunited.nebula.gateway.local.repository.TenantDomainRepository;
import com.bizunited.nebula.gateway.local.repository.TenantInfoRepository;
import com.bizunited.nebula.gateway.local.service.TenantInfoService;
import com.bizunited.nebula.gateway.local.service.internal.TenantInfoVoServiceImpl;
import com.bizunited.nebula.gateway.sdk.vo.TenantInfoVo;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TenantInfoServiceImpl
implements TenantInfoService {
    @Autowired
    private TenantInfoRepository tenantInfoRepository;
    @Autowired
    private BucketInfoRepository bucketInfoRepository;
    @Autowired
    private TenantDomainRepository tenantDomainRepository;
    @Value(value="${server.port:80}")
    private int serverPort;
    @Value(value="${server.ssl.enabled:false}")
    private boolean sslEnable;
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantInfoVoServiceImpl.class);

    @Override
    @Transactional
    public TenantInfoVo create(TenantInfo tenantInfo) {
        Validate.notNull((Object)tenantInfo, (String)"\u9519\u8bef\u7684\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        tenantInfo.setId(null);
        String tenantCode = tenantInfo.getTenantCode();
        Validate.notBlank((CharSequence)tenantCode, (String)"\u9519\u8bef\u7684\u79df\u6237\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        long exsitCount = this.tenantInfoRepository.countByTenantCode(tenantCode);
        Validate.isTrue((exsitCount == 0L ? 1 : 0) != 0, (String)"\u5f53\u524d\u7684\u79df\u6237\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        this.validate(tenantInfo);
        BucketInfo bucketInfo = tenantInfo.getBucketInfo();
        String bucketInfoId = bucketInfo.getId();
        BucketInfo currentBucketInfo = this.bucketInfoRepository.findById(bucketInfoId).orElse(null);
        Set<BucketNodejs> bucketNodes = currentBucketInfo.getBucketNodejss();
        Set<BucketBoot> bucketBoots = currentBucketInfo.getBucketBoots();
        String tenantName = tenantInfo.getTenantName();
        Date now = new Date();
        tenantInfo.setCreateAccount("admin");
        tenantInfo.setCreateTime(now);
        tenantInfo.setModifyAccount("admin");
        tenantInfo.setModifyTime(now);
        tenantInfo.setPreviousBucketInfo(null);
        this.tenantInfoRepository.save(tenantInfo);
        List<TenantDomain> tenantDomains = tenantInfo.getTenantDomains();
        Validate.isTrue((!CollectionUtils.isEmpty(tenantDomains) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u79df\u6237\u57df\u540d\u5173\u8054\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validate(tenantDomains, bucketNodes, bucketBoots);
        for (TenantDomain tenantDomain : tenantDomains) {
            tenantDomain.setTenantInfo(tenantInfo);
            this.tenantDomainRepository.save(tenantDomain);
        }
        TenantInfoVo tenantInfoVo = new TenantInfoVo();
        tenantInfoVo.setTenantCode(tenantCode);
        tenantInfoVo.setTenantName(tenantName);
        if (this.sslEnable) {
            tenantInfoVo.setScheme("https");
        } else {
            tenantInfoVo.setScheme("http");
        }
        tenantInfoVo.setGatewayPort(Integer.valueOf(this.serverPort));
        return tenantInfoVo;
    }

    private void validate(TenantInfo tenantInfo) {
        String channel = tenantInfo.getChannel();
        Validate.notBlank((CharSequence)channel, (String)"\u79df\u6237\u6765\u6e90\u4fe1\u606f\u5fc5\u987b\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Date expireTime = tenantInfo.getExpireTime();
        if (expireTime == null) {
            try {
                tenantInfo.setExpireTime(DateUtils.parseDate((String)"2099-01-01", (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
            }
            catch (ParseException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e);
            }
        }
        BucketInfo bucketInfo = tenantInfo.getBucketInfo();
        Validate.notNull((Object)bucketInfo, (String)"\u9519\u8bef\u7684\u8d44\u6e90\u6876\u4fe1\u606f\uff0c\u8bf7\u9009\u62e9", (Object[])new Object[0]);
        String bucketInfoId = bucketInfo.getId();
        Validate.notBlank((CharSequence)bucketInfoId, (String)"\u8d44\u6e90\u6876\u4fe1\u606f(bucketInfoId)\u5fc5\u987b\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        BucketInfo currentBucketInfo = this.bucketInfoRepository.findById(bucketInfoId).orElse(null);
        Validate.notNull((Object)currentBucketInfo, (String)"\u6ca1\u6709\u627e\u5230\u8bbe\u5b9a\u7684\u8d44\u6e90\u6876\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String remark = tenantInfo.getRemark();
        Validate.notBlank((CharSequence)remark, (String)"\u9519\u8bef\u7684\u79df\u6237\u8bf4\u660e\u4fe1\u606f\uff0c\u8bf7\u586b\u5199", (Object[])new Object[0]);
        tenantInfo.setVirtual(false);
        Integer weight = tenantInfo.getWeight();
        Validate.inclusiveBetween((long)1L, (long)5L, (long)weight.intValue(), (String)"\u79df\u6237\u6743\u91cd\u5fc5\u987b\u8bbe\u5b9a\uff0c\u5176\u4e2d5\u6700\u9ad8\uff0c1\u6700\u4f4e");
        String webKey = tenantInfo.getWebKey();
        Validate.notBlank((CharSequence)webKey, (String)"\u79df\u6237\u7ad9\u70b9\u4fe1\u606f\u4fe1\u606f\u9700\u8981\u586b\u5199\uff08\u4e00\u4e2a\u5b57\u7b26\u5c31\u884c\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String tenantName = tenantInfo.getTenantName();
        Validate.notBlank((CharSequence)tenantName, (String)"\u5f53\u524d\u79df\u6237\u7684\u4e2d\u6587\u540d\u5fc5\u987b\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
    }

    private void validate(List<TenantDomain> tenantDomains, Set<BucketNodejs> bucketNodes, Set<BucketBoot> bucketBoots) {
        for (TenantDomain tenantDomain : tenantDomains) {
            long matchedCount;
            Boolean external = tenantDomain.getExternal();
            Validate.notNull((Object)external, (String)"\u79df\u6237\u5173\u8054\u7684\u670d\u52a1\u57df\u540d\u4fe1\u606f\u4e2d\uff0c\u5fc5\u987b\u8bbe\u5b9a\u5176\u5bf9\u5e94\u7684\u662f\u5916\u90e8\u8282\u70b9\uff08node boot\uff09\u8fd8\u662f\u5185\u90e8\u8282\u70b9\uff08spring boot\uff09", (Object[])new Object[0]);
            Integer appType = tenantDomain.getAppType();
            Validate.notNull((Object)appType, (String)"\u79df\u6237\u670d\u52a1\u57df\u540d\u6d89\u53ca\u7684\u5e94\u7528\u7a0b\u5e8f\u7c7b\u578b\uff0c\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            if (external.booleanValue()) {
                Validate.isTrue((!CollectionUtils.isEmpty(bucketNodes) ? 1 : 0) != 0, (String)"\u5f53\u524d\u8d44\u6e90\u6876\u6ca1\u6709\u4efb\u4f55node\u8282\u70b9\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                matchedCount = bucketNodes.stream().filter(item -> item.getAppType().intValue() == appType.intValue()).count();
                Validate.isTrue((matchedCount != 0L ? 1 : 0) != 0, (String)"\u5f53\u524d\u8d44\u6e90\u6876\u4e2d\uff0c\u5e76\u6ca1\u6709\u6307\u5b9a\u7684\u5e94\u7528\u7a0b\u5e8f\u7c7b\u578b\uff08%d\uff09,\u8bf7\u68c0\u67e5!!", (long)appType.intValue());
            } else {
                Validate.isTrue((!CollectionUtils.isEmpty(bucketBoots) ? 1 : 0) != 0, (String)"\u5f53\u524d\u8d44\u6e90\u6876\u6ca1\u6709\u4efb\u4f55spring boot\u8282\u70b9\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                matchedCount = bucketBoots.stream().filter(item -> item.getAppType().intValue() == appType.intValue()).count();
                Validate.isTrue((matchedCount != 0L ? 1 : 0) != 0, (String)"\u5f53\u524d\u8d44\u6e90\u6876\u4e2d\uff0c\u5e76\u6ca1\u6709\u6307\u5b9a\u7684\u5e94\u7528\u7a0b\u5e8f\u7c7b\u578b\uff08%d\uff09,\u8bf7\u68c0\u67e5!!", (long)appType.intValue());
            }
            String domain = tenantDomain.getDomain();
            Validate.notBlank((CharSequence)domain, (String)"\u5fc5\u987b\u4e3a\u6307\u5b9a\u9876\u7ea7\u79df\u6237\u670d\u52a1\u7684\u5e94\u7528\u7a0b\u5e8f\uff0c\u8bbe\u5b9a\u4e00\u4e2a\u552f\u4e00\u7684\u57df\u540d", (Object[])new Object[0]);
            TenantDomain exsitTenantDomain = this.tenantDomainRepository.findByDomain(domain);
            Validate.isTrue((exsitTenantDomain == null ? 1 : 0) != 0, (String)"\u5fc5\u987b\u4e3a\u6307\u5b9a\u9876\u7ea7\u79df\u6237\u670d\u52a1\u7684\u5e94\u7528\u7a0b\u5e8f\uff0c\u8bbe\u5b9a\u4e00\u4e2a\u552f\u4e00\u7684\u57df\u540d\uff08\u76ee\u524d\u57df\u540d\uff1a%s \u4e0d\u552f\u4e00\uff09", (Object[])new Object[]{domain});
        }
    }

    @Override
    @Transactional
    public TenantInfoVo update(TenantInfo tenantInfo) {
        Validate.notNull((Object)tenantInfo, (String)"\u9519\u8bef\u7684\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String id = tenantInfo.getId();
        Validate.notNull((Object)id, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u4fee\u6539\u79df\u6237\u4fe1\u606f\u7684id\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TenantInfo currentTenantInfo = this.tenantInfoRepository.findById(id).orElse(null);
        Validate.notNull((Object)currentTenantInfo, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u4fee\u6539\u79df\u6237\u4fe1\u606f\u7684\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String tenantCode = tenantInfo.getTenantCode();
        Validate.notBlank((CharSequence)tenantCode, (String)"\u9519\u8bef\u7684\u79df\u6237\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validate(tenantInfo);
        BucketInfo bucketInfo = tenantInfo.getBucketInfo();
        String bucketInfoId = bucketInfo.getId();
        BucketInfo currentBucketInfo = this.bucketInfoRepository.findById(bucketInfoId).orElse(null);
        Set<BucketNodejs> bucketNodes = currentBucketInfo.getBucketNodejss();
        Set<BucketBoot> bucketBoots = currentBucketInfo.getBucketBoots();
        String tenantName = tenantInfo.getTenantName();
        currentTenantInfo.setBucketInfo(bucketInfo);
        currentTenantInfo.setChannel(tenantInfo.getChannel());
        currentTenantInfo.setExpireTime(tenantInfo.getExpireTime());
        currentTenantInfo.setRemark(tenantInfo.getRemark());
        currentTenantInfo.setTenantName(tenantName);
        currentTenantInfo.setWebKey(tenantInfo.getWebKey());
        currentTenantInfo.setWeight(tenantInfo.getWeight());
        Date now = new Date();
        currentTenantInfo.setModifyAccount("admin");
        currentTenantInfo.setModifyTime(now);
        this.tenantInfoRepository.save(tenantInfo);
        this.tenantDomainRepository.deleteByTenantInfo(id);
        this.tenantDomainRepository.flush();
        List<TenantDomain> tenantDomains = tenantInfo.getTenantDomains();
        Validate.isTrue((!CollectionUtils.isEmpty(tenantDomains) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u79df\u6237\u57df\u540d\u5173\u8054\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validate(tenantDomains, bucketNodes, bucketBoots);
        for (TenantDomain tenantDomain : tenantDomains) {
            tenantDomain.setTenantInfo(tenantInfo);
            this.tenantDomainRepository.save(tenantDomain);
        }
        TenantInfoVo tenantInfoVo = new TenantInfoVo();
        tenantInfoVo.setTenantCode(tenantCode);
        tenantInfoVo.setTenantName(tenantName);
        if (this.sslEnable) {
            tenantInfoVo.setScheme("https");
        } else {
            tenantInfoVo.setScheme("http");
        }
        tenantInfoVo.setGatewayPort(Integer.valueOf(this.serverPort));
        return tenantInfoVo;
    }

    @Override
    @Transactional
    public void enable(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5fc5\u987b\u4f20\u5165\u6307\u5b9a\u7684\u79df\u6237\u6280\u672f\u7f16\u53f7id", (Object[])new Object[0]);
        TenantInfo currentTenantInfo = this.tenantInfoRepository.findById(id).orElse(null);
        Validate.notNull((Object)currentTenantInfo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentTenantInfo.setState(true);
        this.tenantInfoRepository.save(currentTenantInfo);
    }

    @Override
    @Transactional
    public void disable(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5fc5\u987b\u4f20\u5165\u6307\u5b9a\u7684\u79df\u6237\u6280\u672f\u7f16\u53f7id", (Object[])new Object[0]);
        TenantInfo currentTenantInfo = this.tenantInfoRepository.findById(id).orElse(null);
        Validate.notNull((Object)currentTenantInfo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        currentTenantInfo.setState(false);
        this.tenantInfoRepository.save(currentTenantInfo);
    }

    @Override
    public List<TenantInfo> findAll() {
        return this.tenantInfoRepository.findAll();
    }

    @Override
    public TenantInfo findDetailsByTenantCode(String tenantCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        TenantInfo tenantInfo = this.tenantInfoRepository.findDetailsByTenantCode(tenantCode);
        return tenantInfo;
    }
}

