/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.websocket.client.local.config;

import com.bizunited.nebula.gateway.websocket.client.local.config.WebsocketClientProperties;
import com.bizunited.nebula.gateway.websocket.client.local.task.MsgSendTask;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

@Configuration
@EnableConfigurationProperties(value={WebsocketClientProperties.class})
public class WebsocketClientConfig {
    private AtomicInteger threadPoolCount = new AtomicInteger(1);

    @Bean(value={"_websocketClientHttpRequestExecutor"})
    public ExecutorService getThreadPoolExecutor() {
        return new ThreadPoolExecutor(10, 15, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = new Thread(r, "websocket_client_httprequest_" + WebsocketClientConfig.this.threadPoolCount.getAndIncrement());
                return newThread;
            }
        });
    }

    @Bean
    @Lazy
    @Scope(value="prototype")
    public MsgSendTask getMsgSendTask(URI serverNode, String tenantCode, String applicationName, String modelCode, String account, String msgBase64) {
        return new MsgSendTask(serverNode, tenantCode, applicationName, modelCode, account, msgBase64);
    }

    @Bean
    @Lazy
    @Scope(value="prototype")
    public MsgSendTask getMsgSendTask(URI serverNode, String tenantCode, String applicationName, String modelCode, String msgBase64) {
        return new MsgSendTask(serverNode, tenantCode, applicationName, modelCode, msgBase64);
    }

    @Bean
    @Lazy
    @Scope(value="prototype")
    public MsgSendTask getMsgSendTask(URI serverNode, String tenantCode, String applicationName, String msgBase64) {
        return new MsgSendTask(serverNode, tenantCode, applicationName, msgBase64);
    }

    @Bean
    @Lazy
    @Scope(value="prototype")
    public MsgSendTask getMsgSendTask(URI serverNode, String tenantCode, String msgBase64) {
        return new MsgSendTask(serverNode, tenantCode, msgBase64);
    }
}

