/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.websocket.client.local.service;

import com.bizunited.nebula.gateway.websocket.client.local.config.WebsocketClientProperties;
import com.bizunited.nebula.gateway.websocket.client.local.task.MsgSendTask;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;

@Service
public class ChannelMsgServiceImpl
implements ChannelMsgService {
    @Autowired
    private WebsocketClientProperties websocketClientProperties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="_websocketClientHttpRequestExecutor")
    private ExecutorService executor;
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelMsgServiceImpl.class);

    public void sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(String tenantCode, String applicationName, String modelCode, String account, byte[] msg) {
        Validate.isTrue((msg != null && msg.length > 0 ? 1 : 0) != 0, (String)" msg not be empty ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)" tenantCode not be blank ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)applicationName, (String)"applicationName not blank ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)modelCode, (String)" modelCode not be blank ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account, (String)" account not be blank ", (Object[])new Object[0]);
        String msgBase64 = Base64Utils.encodeToString((byte[])msg);
        String[] serverNodes = this.websocketClientProperties.getServers();
        Validate.isTrue((serverNodes != null && serverNodes.length > 0 ? 1 : 0) != 0, (String)" not websocket server nodes , please config!", (Object[])new Object[0]);
        for (String serverNode : serverNodes) {
            try {
                URI serverNodeUri = new URI(serverNode);
                MsgSendTask msgSendTask = (MsgSendTask)this.applicationContext.getBean(MsgSendTask.class, new Object[]{serverNodeUri, tenantCode, applicationName, modelCode, account, msgBase64});
                this.executor.submit(msgSendTask);
            }
            catch (RuntimeException | URISyntaxException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public void sendByTenantCodeAndApplicationNameAndModelCode(String tenantCode, String applicationName, String modelCode, byte[] msg) {
        Validate.isTrue((msg != null && msg.length > 0 ? 1 : 0) != 0, (String)" msg not be empty ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)" tenantCode not be blank ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)applicationName, (String)"applicationName not blank ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)modelCode, (String)" modelCode not be blank ", (Object[])new Object[0]);
        String msgBase64 = Base64Utils.encodeToString((byte[])msg);
        String[] serverNodes = this.websocketClientProperties.getServers();
        Validate.isTrue((serverNodes != null && serverNodes.length > 0 ? 1 : 0) != 0, (String)" not websocket server nodes ", (Object[])new Object[0]);
        for (String serverNode : serverNodes) {
            try {
                URI serverNodeUri = new URI(serverNode);
                MsgSendTask msgSendTask = (MsgSendTask)this.applicationContext.getBean(MsgSendTask.class, new Object[]{serverNodeUri, tenantCode, applicationName, modelCode, msgBase64});
                this.executor.submit(msgSendTask);
            }
            catch (RuntimeException | URISyntaxException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public void sendByTenantCodeAndApplicationName(String tenantCode, String applicationName, byte[] msg) {
        Validate.isTrue((msg != null && msg.length > 0 ? 1 : 0) != 0, (String)" msg not be empty ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)" tenantCode not be blank ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)applicationName, (String)"applicationName not blank ", (Object[])new Object[0]);
        String msgBase64 = Base64Utils.encodeToString((byte[])msg);
        String[] serverNodes = this.websocketClientProperties.getServers();
        Validate.isTrue((serverNodes != null && serverNodes.length > 0 ? 1 : 0) != 0, (String)" not websocket server nodes ", (Object[])new Object[0]);
        for (String serverNode : serverNodes) {
            try {
                URI serverNodeUri = new URI(serverNode);
                MsgSendTask msgSendTask = (MsgSendTask)this.applicationContext.getBean(MsgSendTask.class, new Object[]{serverNodeUri, tenantCode, applicationName, msgBase64});
                this.executor.submit(msgSendTask);
            }
            catch (RuntimeException | URISyntaxException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public void sendByTenantCode(String tenantCode, byte[] msg) {
        Validate.isTrue((msg != null && msg.length > 0 ? 1 : 0) != 0, (String)" msg not be empty ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)" tenantCode not be blank ", (Object[])new Object[0]);
        String msgBase64 = Base64Utils.encodeToString((byte[])msg);
        String[] serverNodes = this.websocketClientProperties.getServers();
        Validate.isTrue((serverNodes != null && serverNodes.length > 0 ? 1 : 0) != 0, (String)" not websocket server nodes ", (Object[])new Object[0]);
        for (String serverNode : serverNodes) {
            try {
                URI serverNodeUri = new URI(serverNode);
                MsgSendTask msgSendTask = (MsgSendTask)this.applicationContext.getBean(MsgSendTask.class, new Object[]{serverNodeUri, tenantCode, msgBase64});
                this.executor.submit(msgSendTask);
            }
            catch (RuntimeException | URISyntaxException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public int findMaxBytesLen() {
        return 0;
    }
}

