/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.gateway.websocket.client.local.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgSendTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MsgSendTask.class);
    private URI serverNode;
    private String tenantCode;
    private String applicationName;
    private String modelCode;
    private String account;
    private String msgBase64;

    public MsgSendTask(URI serverNode, String tenantCode, String applicationName, String modelCode, String account, String msgBase64) {
        this.serverNode = serverNode;
        this.tenantCode = tenantCode;
        this.applicationName = applicationName;
        this.modelCode = modelCode;
        this.account = account;
        this.msgBase64 = msgBase64;
    }

    public MsgSendTask(URI serverNode, String tenantCode, String applicationName, String modelCode, String msgBase64) {
        this.serverNode = serverNode;
        this.tenantCode = tenantCode;
        this.applicationName = applicationName;
        this.modelCode = modelCode;
        this.msgBase64 = msgBase64;
    }

    public MsgSendTask(URI serverNode, String tenantCode, String applicationName, String msgBase64) {
        this.serverNode = serverNode;
        this.tenantCode = tenantCode;
        this.applicationName = applicationName;
        this.msgBase64 = msgBase64;
    }

    public MsgSendTask(URI serverNode, String tenantCode, String msgBase64) {
        this.serverNode = serverNode;
        this.tenantCode = tenantCode;
        this.msgBase64 = msgBase64;
    }

    @Override
    public void run() {
        URI targetUri;
        JSONObject context;
        block37: {
            Validate.notNull((Object)this.serverNode, (String)"server node not be blank", (Object[])new Object[0]);
            context = new JSONObject();
            context.put("msgBase64", (Object)this.msgBase64);
            if (StringUtils.isNotBlank((CharSequence)this.tenantCode)) {
                context.put("tenantCode", (Object)this.tenantCode);
            }
            if (StringUtils.isNotBlank((CharSequence)this.applicationName)) {
                context.put("applicationName", (Object)this.applicationName);
            }
            if (StringUtils.isNotBlank((CharSequence)this.modelCode)) {
                context.put("modelCode", (Object)this.modelCode);
            }
            if (StringUtils.isNotBlank((CharSequence)this.account)) {
                context.put("account", (Object)this.account);
            }
            targetUri = null;
            String serverNodeScheme = this.serverNode.getScheme();
            String serverNodeHost = this.serverNode.getHost();
            int serverNodePort = this.serverNode.getPort();
            try {
                if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.tenantCode, this.applicationName, this.modelCode, this.account})) {
                    targetUri = new URI(serverNodeScheme, null, serverNodeHost, serverNodePort, "/v1/websocket/notice/sendByTenantCodeAndApplicationNameAndModelCodeAndAccount", null, null);
                    break block37;
                }
                if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.tenantCode, this.applicationName, this.modelCode})) {
                    targetUri = new URI(serverNodeScheme, null, serverNodeHost, serverNodePort, "/v1/websocket/notice/sendByTenantCodeAndApplicationNameAndModelCode", null, null);
                    break block37;
                }
                if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.tenantCode, this.applicationName})) {
                    targetUri = new URI(serverNodeScheme, null, serverNodeHost, serverNodePort, "/v1/websocket/notice/sendByTenantCodeAndApplicationName", null, null);
                    break block37;
                }
                if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.tenantCode})) {
                    targetUri = new URI(serverNodeScheme, null, serverNodeHost, serverNodePort, "/v1/websocket/notice/sendByTenantCode", null, null);
                    break block37;
                }
                throw new IllegalArgumentException("\u4e1a\u52a1\u7cfb\u7edf\u6a21\u5757\u8981\u6c42websocket\u670d\u52a1\u5668\u53d1\u9001\u6d88\u606f\u65f6\uff0c\u63d0\u4f9b\u4e86\u9519\u8bef\u7684\u53c2\u6570\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!");
            }
            catch (URISyntaxException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e);
            }
        }
        HttpPost httpPost = new HttpPost(targetUri);
        HttpEntity body = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setContentEncoding("utf-8").setBinary(StringUtils.getBytes((String)JSON.toJSONString((Object)context), (Charset)StandardCharsets.UTF_8)).build();
        httpPost.setEntity(body);
        httpPost.setHeader("Content-Type", "application/json");
        try (CloseableHttpClient httpclient = HttpClients.createDefault();
             CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
            HttpEntity responseHttpEntity = response.getEntity();
            String responseText = EntityUtils.toString((HttpEntity)responseHttpEntity);
            JSONObject responseObject = JSONObject.parseObject((String)responseText);
            if (responseObject.getBoolean("success") != Boolean.TRUE) {
                String errorMsg = responseObject.getString("errorMsg");
                throw new IllegalArgumentException(errorMsg);
            }
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }
}

